;; ----------------------------------------------------------- ;;
;;  OKRAG04.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego,
;; inicjalizacje wycinkow zamykajacych OK i CANCEL
;; i inicjalizacje na wycinek typu EDIT_BOX o kluczu "promien"
;; i wycinka TOGGLE o kluczu "osie"
;; Dodatkowo program rysuje okrag  we wskazanym punkcie
;; srodek pobiera z pola edycyjnego okna dialogowego i opcjonalnie
;; rysuje osie symetrii dla tego okregu

(defun c:okrag04 ( / )

  (setq dcl_id(load_dialog "okrag04"))
  (if(not(new_dialog "okrag04" dcl_id))
    (progn
      (alert "Nie znaleziono pliku OKRAG04.DCL")
      (exit)
    );progn
  );if

  (action_tile "promien" "(setq promien (atof $value))")

  (setq osie 0)
  (action_tile "osie" "(setq osie (atoi $value))")

  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)


  (if (= zamkniecie 1)
    (progn

      (setq srodek (getpoint "\nWska punkt rodka okrgu: "))
      (command "_circle" srodek promien "")

      (if (= osie 1)
        (progn
          (setq a (+ promien 3))
          (setq kat_90 (/ pi 2))
          (setq kat_270 (* 3 kat_90))
          (setq p1 (polar srodek kat_90 a))
          (setq p2 (polar srodek kat_270 a))
          (setq p3 (polar srodek 0 a))
          (setq p4 (polar srodek pi a))
          (command "_line" p1 p2 "")
          (command "_line" p3 p4 "")
        );progn
      );if

    );progn
  );if

  (princ zamkniecie)
  (princ osie)

  (princ)
);defun
(princ)
