;; ----------------------------------------------------------- ;;
;;  GENER06.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego
;; oraz inicjalizacje wycinkow zamykajacych OK i CANCEL
;; Program zawiera skladnie wyswietlajaca liste w wycinku 
;; okna dialogowego (o kluczu "elementy"), zostaly 
;; umieszczone skladnie pobierajace dane z pol edycyjnych 
;; zdefiniowanych w oknie dialogowym
;; oraz przypisane domyslne wartosci dla tych wycinkow
;; Program WYSWIETL_SLAJD wyswietla slajdy w wycinku 
;; o kluczu "slajd"
;; Program rysuje element zgodnie z wyborem dokonanym 
;; w oknie dialogowym

(defun c:gener06 ( / p1 p2 p3 p4 p11 p21 p31 p41
                     a b d a1 b1 punkt )

  (setq dcl_id(load_dialog "gener06.dcl"))
  (if(not(new_dialog "gener06" dcl_id))
    (progn
      (alert "Nie znaleziono pliku GENER06.DCL")
      (exit)
    );progn
  );if

  (setq a 20)
  (setq b 10)
  (setq d 5)
  (setq a1 10)
  (setq b1 5)

  (set_tile "a" "20")
  (set_tile "b" "10")
  (set_tile "d" "5")
  (set_tile "a1" "10")
  (set_tile "b1" "5")

  (setq lista_elementow (list "Prostokt 1" "Prostokt 2" "Prostokt 3"))

  (start_list "elementy")
  (mapcar 'add_list lista_elementow)
  (end_list)
  (set_tile "elementy" "0")

  (setq wybor "element1")
  (wyswietl_slajd "slajd" "element1")
  (setq lista_slajdow (list "element1" "element2" "element3"))

  (action_tile "elementy" "(wyswietl_slajd \"slajd\" 
		(nth (atoi $value) lista_slajdow))")

  (action_tile "a"  "(setq a (atof $value))")
  (action_tile "b"  "(setq b (atof $value))")
  (action_tile "d"  "(setq d (atof $value))")
  (action_tile "a1" "(setq a1 (atof $value))")
  (action_tile "b1" "(setq b1 (atof $value))")

  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)

  (if (= zamkniecie 1)
    (progn
      (setq punkt (getpoint "\nWska punkt rodka elementu: "))
      (setq a_2 (/ a 2))
      (setq b_2 (/ b 2))

      (setq p1 (list (- (car punkt) a_2)(+ (cadr punkt) b_2)))        
      (setq p2 (list (+ (car punkt) a_2)(+ (cadr punkt) b_2)))
      (setq p3 (list (+ (car punkt) a_2)(- (cadr punkt) b_2)))        
      (setq p4 (list (- (car punkt) a_2)(- (cadr punkt) b_2)))
      (command "_line" p1 p2 p3 p4 p1 "")

      (if (= wybor "element2")
        (progn
          (command "_circle" punkt "_d" d "")
        );progn
      );if  

      (if (= wybor "element3")
        (progn
          (setq a1_2 (/ a1 2))
          (setq b1_2 (/ b1 2))
          (setq p11 (list (- (car punkt) a1_2)(+ (cadr punkt) b1_2)))        
          (setq p21 (list (+ (car punkt) a1_2)(+ (cadr punkt) b1_2)))
          (setq p31 (list (+ (car punkt) a1_2)(- (cadr punkt) b1_2)))        
          (setq p41 (list (- (car punkt) a1_2)(- (cadr punkt) b1_2)))
          (command "_line" p11 p21 p31 p41 p11 "")
        );progn
      );if
    );progn
  );if

  (princ)
);defun


(defun wyswietl_slajd ( klucz_wycinka nazwa_slajdu / )
  (progn
    (start_image klucz_wycinka)
    (setq dx (dimx_tile klucz_wycinka)) 
    (setq dy (dimy_tile klucz_wycinka))
    (fill_image 0 0 dx dy -2)
    (slide_image 0 0 dx dy nazwa_slajdu)
    (end_image)
    (setq wybor nazwa_slajdu)
  );progn
);defun
