;; ----------------------------------------------------------- ;;
;;  GENER04.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego
;; oraz inicjalizacje wycinkow zamykajacych OK i CANCEL
;; Program zawiera skladnie wyswietlajaca liste w wycinku 
;; okna dialogowego (o kluczu "elementy")
;; Program WYSWIETL_SLAJD wyswietla slajdy w wycinku 
;; o kluczu "slajd"

(defun c:gener04 ( / )

  (setq dcl_id(load_dialog "gener04.dcl"))
  (if(not(new_dialog "gener04" dcl_id))
    (progn
      (alert "Nie znaleziono pliku GENER04.DCL")
      (exit)
    );progn
  );if

  (setq lista_elementow (list "Prostokt 1" "Prostokt 2" "Prostokt 3"))

  (start_list "elementy")
  (mapcar 'add_list lista_elementow)
  (end_list)
  (set_tile "elementy" "0")

  (wyswietl_slajd "slajd" "element1")
  (setq lista_slajdow (list "element1" "element2" "element3"))

  (action_tile "elementy" "(wyswietl_slajd \"slajd\" 
		(nth (atoi $value) lista_slajdow))")


  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)

  (princ)
);defun


(defun wyswietl_slajd ( klucz_wycinka nazwa_slajdu / )
  (progn
    (start_image klucz_wycinka)
    (setq dx (dimx_tile klucz_wycinka)) 
    (setq dy (dimy_tile klucz_wycinka))
    (fill_image 0 0 dx dy -2)
    (slide_image 0 0 dx dy nazwa_slajdu)
    (end_image)
  );progn
);defun
