program cw4_47d;
{ Program wczytuje slowa do tablicy i wyswietla razem }
{ wystepujace w nich anagramy.                        }
{ dyskietka: 4_47d.pas                                }

uses
  Crt;

const
  MaxRozmiar = 20;

type
  TSlowo = record
             Slowo, Posortowane : String;
           end;
  TTablica = array [1..20] of TSlowo;

var
  IleElementow : Byte;

function UpcaseStr (S : String) : String;
{ Funkcja zamienia wszystkie litery w slowie }
var
  I : Byte;
begin
  for I := 1 to Length (S) do
    S[I] := UpCase (S[I]);
end; {--------------------------- UpcaseStr -}

function SortujSlowo (S : String) : String;
{ Funkcja sortuje litery w slowie.           }
var
  I : Byte;
  Pom : Char;
  Zamiana : Boolean;
  Ilosc : Byte;
begin
  repeat
    Zamiana := False;
    Ilosc := Length(S) - 1;
    for I := 1 to Ilosc do
      if (S [I] > S [I+1]) then
      begin
        Pom := S [I]; S [I] := S [I+1]; 
        S [I+1]:= Pom; Zamiana := True;
      end;
  until not Zamiana;
  SortujSlowo := S

end; {------------------------- SortujSlowo -}

procedure SortujTablice (var T : TTablica);
{ Funkcja sortuje tablice rekordow.          }
var
  I : Byte;
  Pom : TSlowo;
  Zamiana : Boolean;
  Ilosc : Byte;
begin
  repeat
    Zamiana := False;
    Ilosc := IleElementow - 1;
    for I := 1 to Ilosc do
      if (T[I].Posortowane > T[I+1].Posortowane) then
      begin
        Pom := T[I]; T[I] := T[I+1]; 
        T[I+1]:= Pom; Zamiana := True;
      end;
  until not Zamiana;
end; {---------------------- SortujTablice -}

var
  I : Byte;
  Slowo : String;
  T : TTablica;

begin
  ClrScr;
  I := 1;

  repeat
    write ('Podaj kolejne slowo (lub Enter aby zakonczyc): '); readln (Slowo);
    if (Slowo <> '') then
    begin
      T[I].Slowo := Slowo;
      T[I].Posortowane := SortujSlowo(Slowo);
      Inc (I);
    end;
  until (Slowo = '') or (I>MaxRozmiar);
  IleElementow := I-1;
  writeln;

  SortujTablice (T);

  I := 1;
  while (I<IleElementow) do
  begin
    write (T[I].Slowo, ' ');
    if (T[I].Posortowane <> T[I+1].Posortowane) then
      writeln;
    Inc (I);
  end;
  write (T[IleElementow].Slowo, ' ');
  writeln;
  readln;
end.