program cw3_56;
{ Program ilustuje dzialanie procedury ktora }
{ oblicza rozwiazania rownania kwadratowego. }
{ dyskietka: 3_56.pas                        }
var
  A, B, C, X1, X2 : Real;
  Liczba          : Byte;

procedure RownanieKwadratowe (A, B, C: Real;
                              var LiczbaRozwiazan : Byte;
                              var X1, X2 : Real);
{ Procedura oblicza pierwiastki rowniania Ax^2+Bx+C=0 }
{ W zmiennej LiczbaRozwiazan zwraca liczbe rozwiazan  }
{ rownania (0, 1 lub 2), w X1 i X2 - rozwiazania.     }
{ Jezeli jest jedno rozwiazanie, jest pamietane w X1, }
{ X2 jest nieokreslone. Jezeli nie ma rozwiazan, X1 i }
{ X2 pozostaje nieokreslone.                          }
var
  Delta : Real;
begin
  Delta := Sqr(B)-4*A*C;
  if (Delta<0) then
    LiczbaRozwiazan := 0
  else
    if (Delta=0) then
    begin
      LiczbaRozwiazan := 1;
      X1 := -B/(2*A);
    end
    else
    begin
      LiczbaRozwiazan := 2;
      X1 := (-B-Sqrt(Delta))/(2*A);
      X2 := (-B+Sqrt(Delta))/(2*A);
    end
end; {--------------------------- RownanieKwadratowe -}

begin
  write ('Podaj A: '); readln (A);
  write ('Podaj B: '); readln (B);
  write ('Podaj C: '); readln (C);
  RownanieKwadratowe (A, B, C, Liczba, X1, X2);
  if (Liczba = 0) then
    writeln ('Brak rozwiazan')
  else
    if (Liczba = 1) then
      writeln ('Jedno rozwiazanie: ', X1:0:2)
    else
      writeln ('Dwa rozwiazania: ', X1:0:2, ' i ', X2:0:2);
  readln;
end.