program cw4_33;
{ Program pokazujacy podstawowe dzialania na stosie: }
{ odkladanie elementu na stos, zdejmowanie ze stosu  }
{ wypisywanie zawartosci stosu.                      }
{ dyskietka: 4_33.pas                                }

uses
  Crt;

type
  TWskaznik = ^TElement;
  TElement  = record
                Slowo : String;
                Nast  : TWskaznik;
              end;

var
  Stos : TWskaznik;
  Slowo : String;
  Znak : Char;

procedure Push (Slowo: String);
{ Procedura odklada slowo na stosie - czyli umieszcza  }
{ go na poczatku listy (o ile nie jest puste).         }
var
  E : TWskaznik;
begin
  if Slowo <> '' then
  begin
    New (E);
    E^.Slowo := Slowo;
    E^.Nast := Stos;
    Stos := E;
  end;
end; {------------------------------------------ Push -}

function Pop: String;
{ Funkcja sciaga ze stosu pierwsze slowo (o ile jest)  }
{ i je zwraca. Jezeli stos jest pusty - zwraca lancuch }
{ pusty.                                               }
var
  E : TWskaznik;
begin
  if (Stos = Nil) then
    Pop := ''
  else
  begin
    E := Stos;
    Pop := E^.Slowo;
    Stos := E^.Nast;
    Dispose (E);
  end;
end; {------------------------------------------ Push -}

procedure WypiszStos;
{ Procedura wypisuje wszystkie elementy stosu.         }
var
  E : TWskaznik;
begin
  E := Stos;
  while E <> nil do
  begin
    writeln (E^.Slowo);
    E := E^.Nast;
  end;
end; {------------------------------------ WypiszStos -}


begin
  Stos := nil;

  repeat
    ClrScr;
    writeln ('P - poloz na stosie, Z - zdejmij ze stosu, ',
             'W - wypisz stos, K - koniec');
    Znak := UpCase(ReadKey);
    case Znak of
      'P' : begin
              repeat
                write ('Podaj niepuste slowo: '); readln (Slowo);
              until (Slowo<>'');
              Push (Slowo);
              write ('Slowo ', Slowo, ' polozone na stosie.')
            end;
      'Z' : begin
              Slowo := Pop;
              if Slowo = '' then
                writeln ('Stos byl pusty')
              else
                writeln ('Ze stosu zdjeto slowo: ', Slowo);
            end;
      'W' : begin
              writeln ('Zawartosc stosu:'); writeln ('================');
              WypiszStos;
            end;
    else
      if Znak <> 'K' then
        writeln ('Zly klawisz.');
    end;
    writeln; write ('Wcisnij Enter aby wrocic do menu'); readln;
  until (Znak = 'K');
end.
