program cw4_58d;
{ Program w zaleznosci od wartosci zmiennej zamiana zmienia  }
{ slowa kluczowe Turbo Pascala na duze lub male. Ponizsza    }
{ lista oczywiscie nie zawiera wszystkich slow kluczowych    }
{ przyklad pokazuje jedynie metode. Mozesz wzbogacic         }
{ go, wypisujac slowa z pomocy Turbo Pascala. Program bedzie }
{ niestety zamienial slowa kluczowe znajdujace sie w         }
{ komentarzach. Pomysl, jak sie przed tym ustrzec.           }
{ dyskietka: 4_58d.pas                                       }

uses
  Crt;

const
  LiczbaSlowKluczowych = 9;
  SlowaKluczowe : array [1..LiczbaSlowKluczowych] of String =
     ('ARRAY', 'BEGIN', 'CONST', 'VAR', 'TYPE', 'END', 'IF', 'THEN', 'ELSE');

  ZnakiDopuszczalne : set of Char = { czy myslisz, ze zbior zawiera wszystkie? }
     [#8, ':', ';', ' ', '[', ']', '(', ')', '.'];

var
  NazwaPliku : String;
  P, I, J : Byte;
  F, G : Text;
  Linia : String;
  PomLinia : String;
  Zamiana : (duze, male);

function Istnieje (S : String) : Boolean;
{ Funkcja sprawdzajaca, czy istnieje plik }
{ o nazwie S.                             }
var
  F : Text;
begin
  Assign (F, S);
  {$I-} Reset (F); {$I+}
  if IOResult=0 then
  begin
    Close (F);
    Istnieje := True;
  end
  else
    Istnieje := False
end; {------------------------- Istnieje -}

function UpcaseStr (S : String) : String;
{ Funkcja jest odpowiednikiem systemowej Upcase }
{ ale dziala na lancuchach, a nie na znakach.   }
var
  Dlugosc, I : Byte;
begin
  Dlugosc := Length (S);
  for I := 1 to Dlugosc do
    S[I] := Upcase(S[I]);
  UpcaseStr := S;
end; {------------------------------ UpcaseStr -}

function LowcaseStr (S : String) : String;
{ Funkcja zamienia wszystkie litery lancucha na }
{ male.                                         }
var
  Dlugosc, I : Byte;
begin
  Dlugosc := Length (S);
  for I := 1 to Dlugosc do
    if (S[I] in ['A'..'Z']) then
      Inc(S[I], Ord('a')-Ord('A'));
  LowcaseStr := S;
end; {----------------------------- LowcaseStr -}

begin
  ClrScr;
  Zamiana := Duze;
  repeat
    write ('Podaj nazwe pliku (lub Enter aby zakonczyc): '); readln (NazwaPliku);
    if ((NazwaPliku<>'') and not (Istnieje (NazwaPliku))) then
      write ('Plik nie istnieje. ');
  until ((NazwaPliku='') or (Istnieje (NazwaPliku)));

  if (NazwaPliku <> '') then
  begin
    Assign (F, NazwaPliku); Reset (F);
    Assign (G, 'DONE.PAS'); Rewrite (G);
    while not Eof (F) do
    begin
      readln (F, Linia);
      for I := 1 to LiczbaSlowKluczowych do
      begin
        PomLinia := LowcaseStr (Linia);
        repeat
          P := Pos (LowcaseStr (SlowaKluczowe[I]), PomLinia);
          if P<>0 then
          begin
            for J := P to P+Length(SlowaKluczowe[I])-1 do
               PomLinia[J] := 'X';
            if ((P=1) or (PomLinia[P-1] in ZnakiDopuszczalne)) and
              ((P+Length(SlowaKluczowe[I])-1 = Length(PomLinia)) or
               (PomLinia[P+Length(SlowaKluczowe[I])] in ZnakiDopuszczalne)) then
               case Zamiana of
                 Duze: for J := P to P+Length(SlowaKluczowe[I])-1 do
                         Linia[J] := Upcase(Linia[J]);
                 Male: for J := P to P+Length(SlowaKluczowe[I])-1 do
                         Linia[J] := Chr(Ord(Upcase(Linia[J]))+32);
               end;

          end;
        until P=0;
      end;
      writeln (G, Linia);
    end;
    Close (G); Close (F);
  end;
end.