program cw4_53d;
{ Program testujacy dzialanie funkcji, obliczajacej }
{ liczbe dni pomiedzy dwoma datami.                 }
{ dyskietka: 4_53d.pas                              }

uses
  Crt;

type
  { Typ rekordowy, w ktorym bedzie pamietana data }
  TData = record
            Dzien, Miesiac : Byte;
            Rok : Integer;
          end;

function LiczbaDniWRoku (Rok : Integer) : Integer;
{ Funkcja podaje liczbe dni w roku Rok. }
begin
  if (Rok mod 4 = 0) and 
     ((Rok mod 100 <> 0) or (Rok mod 400 = 0)) then
    LiczbaDniWRoku := 366 { rok przestepny }
  else
    LiczbaDniWRoku := 365 { rok nie jest przestepny }
end; {----------------------------- LiczbaDniWRoku -}

function LiczbaDniWMiesiacu (Miesiac : Byte; Rok : Integer) : Byte;
{ Funkcja podaje liczbe dni w miesiacu Miesiac roku Rok. }
begin
  case Miesiac of
    1, 3, 5, 7, 8, 10, 12: LiczbaDniWMiesiacu := 31;
    2: if LiczbaDniWRoku (Rok) = 366 then
         LiczbaDniWMiesiacu := 29
       else
         LiczbaDniWMiesiacu := 28
    else
      LiczbaDniWMiesiacu := 30
  end;
end; {---------------------------------------- LiczbaDniWMiesiacu -}

function LiczbaDniDoKoncaMiesiaca (Data : TData) : Byte;
{ Funkcja podaje liczbe dni od podanej daty do konca biezacego }
{ miesiaca.                                                    }
begin
  LiczbaDniDoKoncaMiesiaca := LiczbaDniWMiesiacu (Data.Miesiac, Data.Rok)-Data.Dzien;
end; {------------------------------ LiczbaDniDoKoncaMiesiaca -}

function LiczbaDniDoKoncaRoku (Data : TData) : Integer;
{ Funkcja podaje liczbe dni od podanej daty do konca biezacego }
{ roku.                                                        }

var
  Liczba : Integer;
  I : Byte;
begin
  Liczba := LiczbaDniDoKoncaMiesiaca (Data);
  for I := Data.Miesiac+1 to 12 do
    Liczba := Liczba + LiczbaDniWMiesiacu (I, Data.Rok);
  LiczbaDniDoKoncaRoku := Liczba
end; {---------------------------------- LiczbaDniDoKoncaRoku -}

function DataWieksza (D1, D2 : TData) : Boolean;
{ Funkcja sprawdza, czy data D1 jest wieksza od daty D2. }
var
  D : Boolean;
begin
  D := False;
  if D1.Rok > D2.Rok then
    D := True
  else
    if D1.Rok = D2.Rok then
      if D1.Miesiac > D2.Miesiac then
        D := True
      else
        if D1.Miesiac = D2.Miesiac then
          if D1.Dzien > D2.Dzien then
            D := True;
  DataWieksza := D;
end; {------------------------------------- DataWieksza -}

function LiczbaDniPomiedzyDatami (D1, D2 : TData) : LongInt;
{ Funkcja podaje liczbe dni od dnia D1 do D2. }
var
  Liczba : LongInt;
  I, Mnoznik : Integer;
  Pom : TData;
begin
  if DataWieksza (D1, D2) then
  begin
    Mnoznik := -1;
    Pom := D1; D1 := D2; D2 := Pom;
  end
  else
    Mnoznik := 1;
  Liczba := LiczbaDniDoKoncaRoku (D1);
  for I := D1.Rok+1 to D2.Rok do
    Liczba := Liczba + LiczbaDniWRoku (I);
  Liczba := Liczba - LiczbaDniDoKoncaRoku (D2);
  LiczbaDniPomiedzyDatami := Mnoznik * Liczba;
end; {-------------------------- LiczbaDniPomiedzyDatami -}

var
  D1, D2 : TData;

begin
  ClrScr;

  { tu probuj wstawiac wlasne daty lub zaprogramuj }
  { mozliwosc wpisywania danych przez uzytkownika. }
  D1.Dzien := 22; D1.Miesiac := 2; D1.Rok := 1915;

  D2.Dzien := 18; D2.Miesiac := 6; D2.Rok := 2000;

  writeln ('Liczba dni pomiedzy datami: ',
            LiczbaDniPomiedzyDatami (D1, D2));
  readln;
end.
