program cw4_50d;
{ Program pozwalajacy grac z komputerem w kolko }
{ i krzyzyk.                                    }
{ dyskietka: 4_50d.pas                          }

uses
  Crt;

type
  TPole = (nic, kolko, krzyzyk);

var
  Plansza : array [1..3, 1..3] of TPole;
  I, J, Liczba : Byte;
  Wiersz, Kolumna : Byte;
  Wygral : TPole;

function Pole (I, J : Byte): Char;
{ Funkcja okresla zawartosc pola o wspolrzednych }
{ I i J w celu wypisania go.                     }
begin
  case Plansza [I, J] of
    nic     : Pole := ' ';
    kolko   : Pole := 'o';
    krzyzyk : Pole := 'x';
  end;
end; {------------------------------------ Pole -}

procedure Wypisz;
{ Procedura wypisuje zawartosc planszy. }
begin
  GotoXY (1, 1);
  writeln (' '+Pole(1,1)+' | '+Pole(1,2)+' | '+Pole(1,3)+' ');
  writeln ('---+---+---');
  writeln (' '+Pole(2,1)+' | '+Pole(2,2)+' | '+Pole(2,3)+' ');
  writeln ('---+---+---');
  writeln (' '+Pole(3,1)+' | '+Pole(3,2)+' | '+Pole(3,3)+' ');
end; {------------------------- Wypisz -}

function Sprawdz (P : TPole;
                  W1, K1, W2, K2, W3, K3 : Byte) : Boolean;
{ Funkcja dokonuje sprawdzenia trzech wskazanych pol na }
{ potrzeby funkcji Atak.                                }

var
  IleNic : Byte;
  IleP : Byte;
  A : Array [1..3] of TPole;
begin
  IleP := 0; IleNic := 0;
  A [1] := Plansza [W1, K1];
  A [2] := Plansza [W2, K2];
  A [3] := Plansza [W3, K3];

  for I := 1 to 3 do
    if (A[I] = nic) then Inc (IleNic)
      else if (A[I] = P) then Inc (IleP);
  if (IleP = 2) and (IleNic = 1) then
  begin
    if (A[1] = nic) then Plansza [W1, K1] := kolko
      else if (A[2] = nic) then Plansza [W2, K2] := kolko
        else if (A[3] = nic) then Plansza [W3, K3] := kolko;
    Sprawdz := True;
  end
  else
    Sprawdz := False;
end; {--------------------------------------------- Sprawdz -}

function Atak (P : TPole) : Boolean;
{ Funkcja sprawdza wszelkie linie, czy kolko lub krzyzyk }
{ ma mozliwosc zakonczenia w kolejnym ruchu.             }
var
  O : Boolean;
  I : Byte;
begin
  O := False;
  for I := 1 to 3 do
    if not O then O := Sprawdz (P, I,1, I,2, I,3);
  for I := 1 to 3 do
    if not O then O := Sprawdz (P, 1,I, 2,I, 3,I);
  if not O then O := Sprawdz (P, 1,1, 2,2, 3,3);
  if not O then O := Sprawdz (P, 1,3, 2,2, 3,1);
  Atak := O;
end; {-------------------------------------------- Atak -}

procedure Ruch;
{ Procedura wykonuje ruch kolka }
var
  I, J : Byte;
  Postawiono : Boolean;
begin
  if not Atak(kolko) then
    if not Atak(krzyzyk) then
      if Plansza [2,2] = nic then
        Plansza [2,2] := kolko
      else
        if Plansza [1,1] = nic then
            Plansza [1,1] := kolko
        else
          if Plansza [1,3] = nic then
            Plansza [1,3] := kolko
          else
            if Plansza [3,1] = nic then
              Plansza [3,1] := kolko
            else
              if Plansza [3,3] = nic then
                Plansza [3,3] := kolko
            else
            begin
              Postawiono := False;
              for I := 1 to 3 do
                for J := 1 to 3 do
                  if (Plansza [I, J] = nic) and not Postawiono then
                  begin
                    Plansza [I, J] := kolko;
                    Postawiono := True;
                  end;
            end;
end; {-------------------------- Ruch -}

function SprawdzKoniec (W1, K1, W2, K2, W3, K3 : Byte) : TPole;
{ Funkcja sprawdza, na podancyh 3 polach stoja jednakowe figury. }
var
  IleKolko : Byte;
  IleKrzyzyk : Byte;
  A : Array [1..3] of TPole;
begin
  IleKolko := 0; IleKrzyzyk := 0;
  A [1] := Plansza [W1, K1];
  A [2] := Plansza [W2, K2];
  A [3] := Plansza [W3, K3];

  for I := 1 to 3 do
    if (A[I] = kolko) then Inc (IleKolko)
      else if (A[I] = krzyzyk) then Inc (IleKrzyzyk);

  if IleKolko = 3 then SprawdzKoniec := kolko
    else if IleKrzyzyk = 3 then SprawdzKoniec := krzyzyk
      else SprawdzKoniec := nic
end; {------------------------------------------ SprawdzKoniec -}

function Koniec : TPole;
{ Funkcja sprawdza, czy nastapil koniec rozgrywki. }
var
  O : TPole;
  I : Byte;
begin
  O := nic;
  for I := 1 to 3 do
    if O = nic then O := SprawdzKoniec (I,1, I,2, I,3);
  for I := 1 to 3 do
    if O = nic then O := SprawdzKoniec (1,I, 2,I, 3,I);
  if O = nic then O := SprawdzKoniec (1,1, 2,2, 3,3);
  if O = nic then O := SprawdzKoniec (1,3, 2,2, 3,1);
  Koniec := O;
end; {------------------------------------------------- Koniec -}

begin
  ClrScr;
  for I := 1 to 3 do
    for J := 1 to 3 do
      Plansza [I, J] := nic;

  Liczba := 0;

  repeat
    ClrScr;
    Ruch;
    Inc (Liczba);
    Wypisz;
    writeln;
    Wygral := Koniec;
    if (Liczba<9) and (Wygral=nic) then
    begin
      repeat
        write ('Podaj wiersz i kolumne: '); ClrEol; readln (Wiersz, Kolumna);
      until (Wiersz in [1..3]) and (Kolumna in [1..3])
            and (Plansza[Wiersz, Kolumna] = nic);
      Inc (Liczba);
      Plansza [Wiersz, Kolumna] := krzyzyk;
      Wygral := Koniec;
    end;
  until (Liczba=9) or (Wygral<>nic);

  if Wygral = nic then write ('Remis')
    else if (Wygral = kolko) then write ('Przegrales')
      else write ('Wygral komputer');
  ClrEol;
  readln;
end.