program cw4_45d;
{ Program wypisuje wszystkie permutacje liczb od 1 do N. }
{ dyskietka: 4_45d.pas                                   }

uses
  Crt;

const
  N = 5;

type
  TPerm = Array [1..N] of Byte;

function Silnia (I : Integer) : LongInt;
{ Funkcja oblicza silnie liczby I }
begin
  if I = 1 then
    Silnia := 1
  else
    Silnia := Silnia (I-1) * I
end; {----------------------- Silnia -}

procedure NastPerm (var P : TPerm; B, I : Byte);
{ Procedura oblicza i wypisuje nastepna permutacje }
var
  J  : Byte;
  S  : Set of Byte;
  K  : Byte;
  O  : Boolean;
begin
  O := False;
  J := B+2;
  while (J<=I) and not O do
  begin
    O := P[J-1]<P[J];
    Inc (J);
  end;

  if O then
    NastPerm (P, B+1, I)
  else
  begin
    P[B] := P[B]+1;
    S := [];
    for J := 1 to B-1 do S := S + [P[J]];
    while P[B] in S do Inc (P[B]);
    for J := B+1 to I do
    begin
      S := [];
      for K := 1 to J-1 do S := S + [P[K]];
      for K := I downto 1 do
        P[J] := (P[J]*Byte(K in S) + K * (1-Byte(K in S)))
    end
  end
end; {-------------------------------------- NastPerm -}

var
  Perm : TPerm;
  I, S : LongInt;
  J    : Byte;

begin
  ClrScr;
  write ('  1     ');
  for I := 1 to N do
  begin
    Perm [I] := I;
    write (I, ' ');
  end;
  writeln;

  S := Silnia (N);

  for I := 2 to S do
  begin
    NastPerm (Perm, 1, N);
    write (I:3, '     ');
    for J := 1 to N do
      Write (Perm [J]:3);
    writeln
  end;
  readln;
end.
