program cw4_54d;
{ Program rozwiazuje problem konika szachowego. }
{ Za N. Wirthem ("Algorytmy + ...")             }
{ Katalog r4_11 : 4_54d.pas                     }

const
  Rozmiar = 8;

type
  Wspolrzedne = (WspX, WspY);

const
  Ruchy : Array [1..8, Wspolrzedne] of Integer =
          (( 2,  1), ( 1, 2), (-1, 2), (-2, 1),
           (-2, -1), (-1,-2), ( 1,-2), ( 2,-1));

var
  I, J : Byte;
  Q    : Boolean;
  H    : Array [1..Rozmiar, 1..Rozmiar] of Integer;


procedure Probuj (I     : Integer;      { Znaleziono droge [1 .. I-1]             }
                  X, Y  : Byte;         { dalszej szukamy z punktu (X, Y)         }
                  var Q : Boolean);     { Znaleziono droge [1 .. Rozmiar*Rozmiar] }
{ Procedura "probuje" kolejne ruchy konika szachowego. }
var
  K    : Integer;          { rozpatrujemy K-ty (z 8) ruch konika }
  U, V : Integer;          { nastepny ruch konika                }
  Q1   : Boolean;          { znaleziono rozwiazanie              }
begin
  K := 0;
  repeat
    K := K + 1;                   { sprawdzamy kolejne ruchy konika }
    Q1 := False;                  { zakladamy, ze nie znaleziono    }
    U := X + Ruchy [K, WspX];     { wspolrzedne nastepnego punktu   }
    V := Y + Ruchy [K, WspY];     { dla danego ruchu konika         }
    if (U > 0) and (V > 0) and (U <= Rozmiar) and (V <= Rozmiar) then    { miesci sie na szachownicy }
      if H [U, V] = 0 then               { na tym polu jeszcze nie bylismy }
      begin
        H [U, V] := I;                   { zaznaczmy obecnosc         }
        if I < Rozmiar*Rozmiar then      { jeszcze nie wszystkie pola }
        begin
          Probuj (I+1, U, V, Q1);        { probujemy dalej ...        }
          if not Q1 then H [U, V] := 0   { brak sukcesu - wracamy     }
        end
        else                             { wszystkie pola             }
          Q1 := True                     { jest rozwiazanie           }
      end
  until Q1 or (K=8);      { do momentu, gdy jest rozwiazanie, lub }
                          { wyprobowalismy wszystkie mozliwosci   }
  Q := Q1
end; {----------------------------------------------------------- Probuj -}

begin 
  for I := 1 to Rozmiar do
    for J := 1 to Rozmiar do
      H [I, J] := 0;

  H [1, 1] := 1;                  { startujemy z punktu (1, 1) }

  Probuj (2, 1, 1, Q);

  if Q then                       { znaleziono droge }
    for I := 1 to Rozmiar do
    begin
      for J := 1 to Rozmiar do
        Write (H [I, J]: 5);
      Writeln
    end
  else                            { nie znaleziono drogi }
    Writeln ('Nie istnieje rozwiazanie');
  Writeln;
end.
