unit unit4_42;
{ Procedura Rysuj wyswietla tekst w trybie }
{ graficznym i umoliwia wyjscie z         }
{ programu.                                }
{ Katalog r4_10 : unit4_42.pas             }

interface
procedure Rysuj;
implementation
uses
  WinCrt, Graph;

const
  TypWykresu : Integer = 1;
  Pocz_x    = 180;
  Pocz_y    = 460;
  Wielkosc  = 440;
  Min_wsp   = -5;
  Max_wsp   = 5;

type
  TOrientacja = (Poziomo, Pionowo);

procedure Os(Orientacja : TOrientacja; Wsp_x, Wsp_y, Dlugosc, Min, Maks : Integer);
var
  I, Przesun : Integer;
  Napis : String;
begin
  SetColor(White);
  SetTextStyle(DefaultFont, HorizDir, 1);
  case Orientacja of
    Poziomo : Line(Wsp_x, Wsp_y, Wsp_x+Dlugosc, Wsp_y);
    Pionowo : Line(Wsp_x, Wsp_y, Wsp_x, Wsp_y-Dlugosc);
  end;
  for I := Min to Maks do
  begin
    Przesun := Round((I-Min)*Dlugosc/(Maks-Min));
    Str(I, Napis);
    case Orientacja of
      Poziomo:
      begin
        Line(Wsp_x+Przesun, Wsp_y-3, Wsp_x+Przesun, Wsp_y+3);
        OutTextXY(Wsp_x+Przesun-(TextWidth(Napis) div 2), Wsp_y+6, Napis);
      end;
      Pionowo:
      begin
        Line(Wsp_x-3, Wsp_y-Przesun, Wsp_x+3, Wsp_y-Przesun);
        OutTextXY(Wsp_x-TextWidth(Napis)-4, Wsp_y-Przesun-3, Napis);
      end;
    end;
  end;
end;

procedure RysujLegende;
const
  Legenda : array[0..10] of String =
  ('Esc - koniec', '1 - Sin(x)',   '2 - Cos(x)',   '3 - ArcTg(x)',
   '4 - Exp(x)',   '5 - Int(x)',   '6 - Frac(x)',  '7 - Sqr(x)',
   '8 - Abs(x)',   '<-,->  - ',    ' - pomiar');
var
  I : Integer;
begin
  SetTextStyle(TriplexFont, HorizDir, 2);
  for I := 0 to 10 do
  begin
    if I = TypWykresu then
      SetColor(White)
    else
      SetColor(LightGreen);
    OutTextXY(10, 10+35*I, Legenda[I]);
  end;
end;

procedure Rysuj;
var
  Znak        : Char;
  Koniec      : Boolean;
begin
  Znak := '1';
  Koniec := False;
  while not Koniec do
  begin
    if Znak <> #0 then
    begin
      if Znak in ['1'..'8'] then
      begin
        TypWykresu := Ord(Znak)-Ord('0');
        Os(Poziomo, Pocz_x, Pocz_y, Wielkosc, Min_wsp, Max_wsp);
        Os(Pionowo, Pocz_x, Pocz_y, Wielkosc, Min_wsp, Max_wsp);
        RysujLegende;
      end;
    end
    else
      Znak := ReadKey;
    Znak := ReadKey;
    if Znak = #27 then Koniec := True;
  end;
end;

end.
