/*
** Szuka w cigu s1 pierwszego z prawej strony wystpienia cigu
** s2 i zwraca wskanik na jego pocztek.
*/
#include <string.h>

char*
moj_strrstr( char const *s1, char const *s2 )
{
    register char    *ostatni;
    register char    *biezacy;

    /*
    ** Inicjalizacja wskanika dla ostatniego znalezionego wystpienia.
    */
    ostatni = NULL;

    /*
    ** Wyszukiwanie tylko wtedy, gdy drugi cig nie jest pusty. Jeeli cig s2 
    ** jest pusty, funkcja zwraca NULL.
    */
    if( *s2 != '\0' ){
        /*
        ** Wyszukaj pierwsze miejsce gdzie s2 wystpuje w s1.
        */
        biezacy = strstr( s1, s2 );

        /*
        ** Za kadym znalezieniem cigu zapamitaj wskanik do jego pocztku
        ** Nastpnie szukaj nastpnego wystpienia cigu.
        */
        while( biezacy != NULL ){
            ostatni = biezacy;
            biezacy = strstr( ostatni + 1, s2 );
        }
    }

    /*
    ** Zwraca wskanik na ostatnie znalezione wystpienie.
    */
    return ostatni;
}
