/*
** Uporzdkowane drzewo binarne implementowane przez
** dynamicznie tworzon struktur.
*/
#include "drzewo.h"
#include <assert.h>
#include <stdio.h>
#include <malloc.h>

/*
**    Struktura WezelDrzewo przechowuje warto i wskaniki do wzw drzewa.
*/
typedef struct WEZEL_DRZEWO {
    TYP_DRZEWA           wartosc;
    struct WEZEL_DRZEWO  *lewo;
    struct WEZEL_DRZEWO  *prawo;
} WezelDrzewo;

/*
**    Wskanik do wza korzenia drzewa.
*/
static    WezelDrzewo    *drzewo;

/*
**    wstaw
*/
void
wstaw( TYP_DRZEWA wartosc )
{
    WezelDrzewo    *biez;
    WezelDrzewo    **polaczenie;

    /*
    ** Rozpocznij od korzenia.
    */
    polaczenie = &drzewo;

    /*
    ** Dopki nie znajdziesz wartoci, przejd do waciwego poddrzewa.
    */
    while( (biez = *polaczenie) != NULL ){
        /*
        ** Przejd do lewego lub prawego poddrzewa, zgodnie z definicj.
        ** (i upewnij si, e nie ma powtarzanych wartoci!).
        */
        if( wartosc < biez->wartosc )
            polaczenie = &biez->lewo;
        else {
            assert( wartosc != biez->wartosc );
            polaczenie = &biez->prawo;
        }
    }
    
    /*
    ** Utwrz nowy wze i zmodyfikuj odpowiednie pole czce 
    ** wskazujace na niego.
    */
    biez = malloc( sizeof( WezelDrzewo ) );
    assert( biez != NULL );
    biez->wartosc = wartosc;
    biez->lewo = NULL;
    biez->prawo = NULL;
    *polaczenie = biez;
}

/*
**    szukaj
*/
TYP_DRZEWA *
szukaj( TYP_DRZEWA wartosc )
{
    WezelDrzewo    *biez;

    /*
    ** Rozpocznij od wza korzenia. Dopki nie odszukasz wartoci
    ** przejd do waciwego poddrzewa.
    */
    biez = drzewo;

    while( biez != NULL && biez->wartosc != wartosc ){
        /*
        ** Przejd do lewego lub prawego poddrzewa, zgodnie z definicj.
        */
        if( wartosc < biez->wartosc )
            biez = biez->lewo;
        else
            biez = biez->prawo;
    }
    
    if( biez != NULL )
        return &biez->wartosc;
    else
        return NULL;
}

/*
** wyk_przeszukiwanie_wzdluz
**    Zrealizuj jeden poziom przeszukiwania wzdu. Ta funkcja pomocnicza 
**    jest potrzebna do zapamitywania informacji na temat wanie 
**    przetwarzanego wza; nie jest to cz interfejsu klienta.
*/
static void
wyk_przeszukiwanie_wzdluz( WezelDrzewo *biez,
    void (*wywolanie)( TYP_DRZEWA wartosc ) )
{
    if( biez != NULL ){
        wywolanie( biez->wartosc );
        wyk_przeszukiwanie_wzdluz( biez->lewo, wywolanie );
        wyk_przeszukiwanie_wzdluz( biez->prawo, wywolanie );
    }
}

/*
** przeszukiwanie_wzdluz
*/
void
przeszukiwanie_wzdluz( void (*wywolanie)( TYP_DRZEWA wartosc ) )
{
    wyk_przeszukiwanie_wzdluz( drzewo, wywolanie );
}
