/*
** Demonstruje sortowanie tablicy struktur za pomoc qsort
*/
#include <stdlib.h>
#include <string.h>

typedef    struct    {
    char    klucz[ 10 ];    /* klucz sortujcy dla tablicy */
    int     inne_dane;      /* dane przypisane do klucza */
} Rekord;

/*
** Funkcja porownawcza: porwnuje tylko wartoci klucza.
*/
int r_porownaj( void const *a, void const *b ){
    return strcmp( ((Rekord *)a)->klucz, ((Rekord *)b)->klucz );
}

int
main()
{
    Rekord    tablica[ 50 ];

    /*
    ** Tutaj kod wypeniajcy tablic 50 elementami.
    */

    qsort( tablica, 50, sizeof( Rekord ), r_porownaj );

    /*
    ** Tablica jest teraz posortowana wg pola kluczowego w strukturze.
    */

    return EXIT_SUCCESS;
}
