/*
** Wstawianie do uporzdkowanej listy jednokierunkowej. Argumentami
** s: wskanik do wskanika korzenia listy i warto do wstawienia.
*/
#include <stdlib.h>
#include <stdio.h>
#include "wezel_poj.h"

#define    FALSE    0
#define    TRUE    1

int
wstaw_lista_poj( register Wezel **polacz_wsk, int nowa_wart )
{
    register Wezel    *biez;
    register Wezel    *nowy;

    /*
    ** Szukanie waciwego miejsca poprzez przegldanie listy
    ** do momentu znalezienia wza, ktrego warto jest wiksza
    ** lub rwna nowej wartoci.
    */
    while( ( biez = *polacz_wsk ) != NULL &&
        biez->wartosc < nowa_wart )
        polacz_wsk = &biez->polaczenie;

    /*
    ** Utworzenie nowego wza i zapamitanie w nim nowej wartoci.
    ** W przypadku niepowodzenia, zwracana jest warto FALSE.
    */
    nowy = (Wezel *)malloc( sizeof( Wezel ) );
    if( nowy == NULL )
        return FALSE;
    nowy->wartosc = nowa_wart;

    /*
    ** Wstawienie nowego wza do listy i zwrcenie TRUE.
    */
    nowy->polaczenie = biez;
    *polacz_wsk = nowy;
    return TRUE;
}
