/*
** Wstawianie do uporzdkowanej listy jednokierunkowej. Argumentami
** s: wskanik do pierwszego wza listy i warto do wstawienia.
*/
#include <stdlib.h>
#include <stdio.h>
#include "wezel_poj.h"

#define    FALSE    0
#define    TRUE    1

int
wstaw_lista_poj( Wezel *biez, int nowa_wart )
{
    Wezel    *poprzedni;
    Wezel    *nowy;

    /*
    ** Szukanie wasciwego miejsca poprzez przegldanie listy
    ** do momentu znalezienia wza, ktrego warto jest wiksza
    ** lub rwna nowej wartoci.
    */
    while( biez->wartosc < nowa_wart ){
        poprzedni = biez;
        biez = biez->polaczenie;
    }

    /*
    ** Utworzenie nowego wza i zapamitanie w nim nowej wartoci.
    ** W przypadku niepowodzenia, zwracana jest warto FALSE.
    */
    nowy = (Wezel *)malloc( sizeof( Wezel ) );
    if( nowy == NULL )
        return FALSE;
    nowy->wartosc = nowa_wart;

    /*
    ** Wstawienie nowego wza do listy i zwrcenie TRUE.
    */
    nowy->polaczenie = biez;
    poprzedni->polaczenie = nowy;
    return TRUE;
}
