/*
** Wstawienie wartoci do listy dwukierunkowej. korzen_wsk jest wskanikiem na
** wze korzenia a wartosc jest now, wstawian wartoci.
** Zwraca: 0 jeeli warto jest ju w licie, -1 jeeli nie ma pamici
** na utworzenie nowego wza, 1 po udanym wstawieniu wza
*/
#include <stdlib.h>
#include <stdio.h>
#include "wezel_podw.h"

int
wstaw_lista_podw( register Wezel *korzen_wsk, int wartosc )
{
    register Wezel    *biez;
    register Wezel    *nast;
    register Wezel    *nowyWezel;

    /*
    ** Sprawdzenie, czy wartosc znajduje si w licie; jeeli tak, 
    ** koniec funkcji. W przeciwnym przypadku przydzielenie nowego wza
    ** na wartosc ("nowyWezel" bdzie na niego wskazywa). "biez" wskazuje na 
    ** wze przed ktr ma by wstawiona nowa wartosc, "nast" wskazuje na 
    ** wze po nim.
    */
    for( biez = korzen_wsk; (nast = biez->przod) != NULL; biez = nast ){
        if( nast->wartosc == wartosc )
            return 0;
        if( nast->wartosc > wartosc )
            break;
    }
    nowyWezel = (Wezel *)malloc( sizeof( Wezel ) );
    if( nowyWezel == NULL )
        return -1;
    nowyWezel->wartosc = wartosc;

    /*
    ** Dodanie nowego wza do listy.
    */
    nowyWezel->przod = nast;
    biez->przod = nowyWezel;

    if( biez != korzen_wsk )
        nowyWezel->tyl = biez;
    else
        nowyWezel->tyl = NULL;

    if( nast != NULL )
        nast->tyl = nowyWezel;
    else
        korzen_wsk->tyl = nowyWezel;

    return 1;
}
