/*
** Wstawienie wartoci do listy dwukierunkowej. korzen_wsk jest wskanikiem na
** wze korzenia a wartosc jest now, wstawian wartoci.
** Zwraca: 0 jeeli warto jest ju w licie, -1 jeeli nie ma pamici
** na utworzenie nowego wza, 1 po udanym wstawieniu wza
*/
#include <stdlib.h>
#include <stdio.h>
#include "wezel_podw.h"

int
wstaw_lista_podw( Wezel *korzen_wsk, int wartosc )
{
    Wezel    *biez;
    Wezel    *nast;
    Wezel    *nowyWezel;

    /*
    ** Sprawdzenie, czy wartosc znajduje si w licie; jeeli tak, 
    ** koniec funkcji. W przeciwnym przypadku przydzielenie nowego wza
    ** na wartosc ("nowyWezel" bdzie na niego wskazywa). "biez" wskazuje na 
    ** wze przed ktr ma by wstawiona nowa wartosc, "nast" wskazuje na 
    ** wze po nim.
    */
    for( biez = korzen_wsk; (nast = biez->przod) != NULL; biez = nast ){
        if( nast->wartosc == wartosc )
            return 0;
        if( nast->wartosc > wartosc )
            break;
    }
    nowyWezel = (Wezel *)malloc( sizeof( Wezel ) );
    if( nowyWezel == NULL )
        return -1;
    nowyWezel->wartosc = wartosc;

    /*
    ** Dodanie nowego wza do listy.
    */
    if( nast != NULL ){
        /*
        ** Przypadek 1 lub 2: nie jest to koniec listy
        */
        if( biez != korzen_wsk ){       /* Przypadek 1: nie na pocztku */
            nowyWezel->przod = nast;
            biez->przod = nowyWezel;
            nowyWezel->tyl = biez;
            nast->tyl = nowyWezel;
        }
        else {               /* Przypadek 2: na pocztku */
            nowyWezel->przod = nast;
            korzen_wsk->przod = nowyWezel;
            nowyWezel->tyl = NULL;
            nast->tyl = nowyWezel;
        }
    }
    else {
        /*
        ** Przypadek 3 lub 4: na kocu listy
        */
        if( biez != korzen_wsk ){       /* Przypadek 3: nie na pocztku */
            nowyWezel->przod = NULL;
            biez->przod = nowyWezel;
            nowyWezel->tyl = biez;
            korzen_wsk->tyl = nowyWezel;
        }
        else {               /* Przypadek 4: na pocztku */
            nowyWezel->przod = NULL;
            korzen_wsk->przod = nowyWezel;
            nowyWezel->tyl = NULL;
            korzen_wsk->tyl = nowyWezel;
        }
    }
    return 1;
}
