/*
** Przetwarzanie wierszy przez czenie znakw z 
** wskazanych kolumn. Wiersze wyjciowe s zakaczane znakami NUL.
*/
void
zmiana( char *wyjscie, char const *wejscie,
    int const il_kolumn, int const kolumny[] )
{
        int        kol;                    /* indeks dla tablicy kolumny  */
        int        kol_wyn;                /* licznik kolumn wyjciowych  */
        int        dlugosc;                /* dugo wiersza wejciowego */

        dlugosc = strlen( wejscie );
        kol_wyn = 0;

        /*
        ** Przetwarzaj kad par numerw kolumn.
        */
        for( kol = 0; kol < il_kolumn; kol += 2 ){
                int        ilznakow = kolumny[kol + 1] - kolumny[kol] + 1;

                /*
                ** Jeeli wiersz wejciowy jest za krtki, opu zakres.
                */
                if( kolumny[kol] >= dlugosc )
                        continue;

                /*
                ** Jeeli tablica wyjciowa jest pena, skoczylimy.
                */
                if( kol_wyn == MAKS_WEJSC - 1 )
                        break;

                /*
                ** Jeeli nie ma miejsca w tablicy wyjciowej, kopiuj tylko
                ** to co si zmieci.
                */
                if( kol_wyn + ilznakow > MAKS_WEJSC - 1 )
                        ilznakow = MAKS_WEJSC - kol_wyn - 1;

                /*
                ** Sprawd ile znakw wiersza wejciowego znajduje si 
                ** w biecym zakresie. Jeeli jest to mniej ni ilznakow,
                ** skoryguj ilznakow.
                */
                if( kolumny[kol] + ilznakow - 1 >= dlugosc )
                        ilznakow = dlugosc - kolumny[kol];

                /*
                ** KOpiuj odpowiednie dane.
                */
                strncpy( wyjscie + kol_wyn, wejscie + kolumny[kol],
                    ilznakow );
                kol_wyn += ilznakow;
        }

        wyjscie[kol_wyn] = '\0';
}
