/*
** Oblicza podatek federalny USA z roku 1995 dla osoby stanu wolnego.
*/

#include <float.h>

static double   granice_doch[]
        = { 0,    23350,  56550,   117950,  256500, DBL_MAX };
static        float        podstawa_opod[]
        = { 0,    3502.5, 12798.5, 31832.5, 81710.5 };
static        float        procent[]
        = { .15,  .28,    .31,     .36,     .396 };

double
podatek_kawaler( double dochody )
{
        int        kategoria;

        /*
        ** Znajd odpowiedni aktegori dochodw. Staa DBL_MAX umieszczona
        ** na kocu listy gwarantuje prawidowe przerwanie dziaania ptli
        */
        for( kategoria = 1;
            dochody >= granice_doch[ kategoria ];
            kategoria += 1 )
                ;
        kategoria -= 1;

        /*
        ** Oblicz podatek.
        */
        return podstawa_opod[ kategoria ] + procent[ kategoria ] *
            ( dochody - granice_doch[ kategoria ] );
}
