/*
** Oblicza procentowy udzia znakw odczytywanych ze standardowego wejcia
** w rnych kategoriach znakw.
*/
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

/*
**        Defincja funkcji sprawdzajcej, czy znak nie jest drukowalny;
**        eliminuje to specjalny przypadek dla tej kategorii
**        w poniszym kodzie.
*/
int is_not_print( int zn )
{
        return !isprint( zn );
}

/*
**        Tablica skoku z funkcjami klasyfikujcymi dla kadej z kategorii.
*/
static        int        (*funkcje_test[])( int ) = {
        iscntrl,
        isspace,
        isdigit,
        islower,
        isupper,
        ispunct,
        is_not_print
};
#define        IL_KATEGORII        \
            ( sizeof( funkcje_test ) / sizeof( funkcje_test[ 0 ] ) )

/*
**        Nazwa kadej z kategorii znakw.
*/
char        *etykieta[] = {
        "sterujcych",
        "odstpw",
        "cyfr",
        "maych liter",
        "wielkich liter",
        "zn. przestankowych",
        "niedrukowalnych"
};

/*
**        Ilo znakw napotkanych w kadej kategorii oraz 
**        cakowita liczba znakw.
*/
int        licznik[ IL_KATEGORII ];
int        suma;

main()
{
        int        zn;
        int        kategoria;

        /*
        ** Odczytaj i przetwrz kolejne znaki
        */
        while( (zn = getchar()) != EOF ){
                suma += 1;

                /*
                ** Wywoanie kolejnych funkcji testowych dla tego 
                ** znaku; jeeli wynikiem jest true, zwikszany jest 
                ** odpowiedni licznik.
                */
                for( kategoria = 0; kategoria < IL_KATEGORII;
                    kategoria += 1 ){
                        if( funkcje_test[ kategoria ]( zn ) )
                                licznik[ kategoria ] += 1;
                }
        }

        /*
        ** Drukowanie wynikw.
        */
        if( suma == 0 ){
                printf( "Brak znakw wejciowych!\n" );
        }
        else {
                for( kategoria = 0; kategoria < IL_KATEGORII;
                    kategoria += 1 ){
                        printf( "%3.0f%% znakw %s\n",
                            licznik[ kategoria ] * 100.0 / suma,
                            etykieta[ kategoria ] );
                }
        }

        return EXIT_SUCCESS;
}
