/*
** Wyszukuje i drukuje wszystkie wiersze w podanych plikach,
** ktre zawieraj podany cig.
**
**        Uycie:
**                fgrep cig plik [ plik ... ]
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define        ROZM_BUFORA        512

void
szukaj( char *nazwa_pliku, FILE *strumien, char *ciag )
{
        char        buffer[ ROZM_BUFORA ];

        while( fgets( buffer, ROZM_BUFORA, strumien ) != NULL ){
                if( strstr( buffer, ciag ) != NULL ){
                        if( nazwa_pliku != NULL )
                                printf( "%s:", nazwa_pliku );
                        fputs( buffer, stdout );
                }
        }
}

int
main( int ac, char **av )
{
        char        *ciag;

        if( ac <= 1 ){
                fprintf( stderr, "Uycie: fgrep ciag plik ...\n" );
                exit( EXIT_FAILURE );
        }

        /*
        ** Odczytanie cigu.
        */
        ciag = *++av;

        /*
        ** Przetwarzanie plikw.
        */
        if( ac <= 2 )
                szukaj( NULL, stdin, ciag );
        else {
                while( *++av != NULL ){
                        FILE        *strumien;

                        strumien = fopen( *av, "r" );
                        if( strumien == NULL )
                                perror( *av );
                        else {
                                szukaj( *av, strumien, ciag );
                                fclose( strumien );
                        }
                }
        }

        return EXIT_SUCCESS;
}
