/*
** Kolejka implementowana z zastosowaniem listy jednokierunkowej. 
** Kolejka ta nie ma ograniczenia wielkoci.
*/
#include "kolejka.h"
#include <stdio.h>
#include <assert.h>

/*
**        Definicja struktury do przechowywania jednej wartoci. Pole 
**        poczeniowe wskazuje na nastpn warto w kolejce.
*/
typedef        struct        WEZEL_KOLEJKA {
        TYP_KOLEJKI          wartosc;
        struct WEZEL_KOLEJKA *nast;
} WezelKolejka;

/*
**        Wskaniki na pierwszy i ostatni wze w kolejce.
*/
static        WezelKolejka        *przod;
static        WezelKolejka        *tyl;

/*
**        usun_kolejke
*/
void
usun_kolejke( void )
{
        while( !pusty() )
                usun();
}

/*
**        wstaw
*/
void
wstaw( TYP_KOLEJKI wartosc )
{
        WezelKolejka        *nowy_wezel;

        /*
        ** Przydzielenie nowego wza i wypenienie pl.
        */
        nowy_wezel = (WezelKolejka *)malloc( sizeof( WezelKolejka ) );
        assert( nowy_wezel != NULL );
        nowy_wezel->wartosc = wartosc;
        nowy_wezel->nast = NULL;

        /*
        ** Wstawienie na koniec kolejki.
        */
        if( tyl == NULL ){
                przod = nowy_wezel;
        }
        else {
                tyl->nast = nowy_wezel;
        }
        tyl = nowy_wezel;
}

/*
**        usun
*/
void
usun( void )
{
        WezelKolejka        *nast_wezel;

        /*
        ** Usuwanie wza z przodu kolejki. Jeeli jest to ostatni wze, 
        ** naley rwnie ustawi wskanik tyl na NULL.
        */
        assert( !pusty() );
        nast_wezel = przod->nast;
        free( przod );
        przod = nast_wezel;
        if( przod == NULL )
                tyl = NULL;
}

/*
**        pierwszy
*/
TYP_KOLEJKI pierwszy( void )
{
        assert( !pusty() );
        return przod->wartosc;
}

/*
**        pusty
*/
int
pusty( void )
{
        return przod == NULL;
}

/*
**        pelny
*/
int
pelny( void )
{
        return 0;
}
