/*
** Abstrakcyjny typ danych do tworzenia listy adresw.
*/

#include "lista_adr.h"
#include <stdio.h>

/*
**    Trzy czci kadego adresu s przechowywane w odpowiadajcych
**    sobie elementach trzech tablic.
*/
static    char    nazwa[MAX_IL_ADRESOW][NAZWA_DLUGOSC];
static    char    adres[MAX_IL_ADRESOW][ADR_DLUGOSC];
static    char    telefon[MAX_IL_ADRESOW][TELEFON_DLUGOSC];

/*
**    Funkcja szuka w tablicy nazwy i zwraca indeks znalezionej lokalizacji.
**    Jeeli nazwa nie istnieje, zwracana jest warto -1.
*/
static int
szukaj_poz( char const *nazwa_do_znalezienia )
{
    int    pozycja;

    for( pozycja = 0; pozycja < MAX_IL_ADRESOW; pozycja += 1 )
        if( strcmp( nazwa_do_znalezienia, nazwa[ pozycja ] ) == 0 )
            return pozycja;

    return -1;
}

/*
**    Na podstawie podanej nazwy wyszukuje i zwraca odpowiadajcy jej adres. 
**    Jeeli nazwa nie zostanie znaleziona, zwracany jest wskanik NULL.
*/
char const *
szukaj_adres( char const *nazwa )
{
    int    pozycja;

    pozycja = szukaj_poz( nazwa );
    if( pozycja == -1 )
        return NULL;
    else
        return adres[ pozycja ];
}

/*
**    Na podstawie podanej nazwy wyszukuje i zwraca odpowiadajcy jej 
**    numer telefonu. Jeeli nazwa nie zostanie znaleziona, zwracany 
**    jest wskanik NULL.
*/
char const *
szukaj_telefon( char const *nazwa )
{
    int    pozycja;

    pozycja = szukaj_poz( nazwa );
    if( pozycja == -1 )
        return NULL;
    else
        return telefon[ pozycja ];
}
