/*
** Stos implementowany z uyciem tablicy statycznej. Rozmiar tablicy moe 
** by zmieniany przez zmian definicji #define i ponown kompilacj moduu.
*/
#include "stos.h"
#include <assert.h>

#define    ROZMIAR_STOSU    100    /* Maksymalna liczba wartoci na stosie */

/*
**    Tablica przechowujca wartoci na stosie oraz wskanik do 
**    wartoci na szczycie stosu.
*/
static    TYP_STOSU  stos[ ROZMIAR_STOSU ];
static    int        g_element = -1;

/*
**    push
*/
void
push( TYP_STOSU wartosc )
{
    assert( !pelny() );
    g_element += 1;
    stos[ g_element ] = wartosc;
}

/*
**    pop
*/
void
pop( void )
{
    assert( !pusty() );
    g_element -= 1;
}

/*
**    top
*/
TYP_STOSU top( void )
{
    assert( !pusty() );
    return stos[ g_element ];
}

/*
**    pusty
*/
int
pusty( void )
{
    return g_element == -1;
}

/*
**    pelny
*/
int
pelny( void )
{
    return g_element == ROZMIAR_STOSU - 1;
}
