/*
** Kolejka implementowana w tablicy statycznej. Rozmiar tablicy moe 
** by zmieniany jedynie przez zmian dyrektywy #define i ponown
** kompilacj moduu.
*/
#include "kolejka.h"
#include <stdio.h>
#include <assert.h>

#define    ROZMIAR_KOLEJKI    100    /* Maksymalna liczba wartoci w kolejce */
#define    ROZMIAR_TABLICY    ( ROZMIAR_KOLEJKI + 1 )     /* Rozmiar tablicy */

/*
**    Tablica przechowujca wartoci z kolejki 
**    oraz wskaniki na pocztek i koniec kolejki.
*/
static    TYP_KOLEJKI   kolejka[ ROZMIAR_TABLICY ];
static    size_t        przod = 1;
static    size_t        tyl = 0;

/*
**    wstaw
*/
void
wstaw( TYP_KOLEJKI wartosc )
{
    assert( !pelny() );
    tyl = ( tyl + 1 ) % ROZMIAR_TABLICY;
    kolejka[ tyl ] = wartosc;
}

/*
**    usun
*/
void
usun( void )
{
    assert( !pusty() );
    przod = ( przod + 1 ) % ROZMIAR_TABLICY;
}

/*
**    pierwszy
*/
TYP_KOLEJKI pierwszy( void )
{
    assert( !pusty() );
    return kolejka[ przod ];
}

/*
**    pusty
*/
int
pusty( void )
{
    return ( tyl + 1 ) % ROZMIAR_TABLICY == przod;
}

/*
**    pelny
*/
int
pelny( void )
{
    return ( tyl + 2 ) % ROZMIAR_TABLICY == przod;
}
