/*
** Uporzdkowane drzewo binarne zaimplementowane w tablicy statycznej.
** Wielko tablicy moe by zmieniana przez zmian definicji #define
** i ponown kompilacj moduu.
*/
#include "drzewo.h"
#include <assert.h>
#include <stdio.h>

#define    ROZMIAR_DRZEWA     100    /* Maks. liczba wartoci w drzewie */
#define    ROZMIAR_TABLICY    ( ROZMIAR_DRZEWA + 1 )

/*
**    Tablica przechowujca wartoci w drzewie.
*/
static    TYP_DRZEWA    drzewo[ ROZMIAR_TABLICY ];

/*
** lewe_dziecko 
**    Oblicza indeks lewego dziecka wza.
*/
static int
lewe_dziecko( int biez )
{
    return biez * 2;
}

/*
** prawe_dziecko
**    Oblicza indeks prawego dziecka wza.
*/
static int
prawe_dziecko( int biez )
{
    return biez * 2 + 1;
}

/*
** wstaw
*/
void
wstaw( TYP_DRZEWA wartosc )
{
    int    biez;

    /*
    ** Sprawd, czy warto jest rna od zera, poniewa zero
    ** wskazuje na nieuywany wze.
    */
    assert( wartosc != 0 );

    /*
    ** Zaczynamy od wza korzenia.
    */
    biez = 1;

    /*
    ** Przejd do waciwego poddrzewa a do osignicia licia.
    */
    while( drzewo[ biez ] != 0 ){
        /*
        ** Przejd do lewego lub prawego poddrzewa, zgodnie z definicj
        ** (i upewnij si, e nie ma powtarzanych wartoci!).
        */
        if( wartosc < drzewo[ biez ] )
            biez = lewe_dziecko( biez );
        else {
            assert( wartosc != drzewo[ biez ] );
            biez = prawe_dziecko( biez );
        }
        assert( biez < ROZMIAR_TABLICY );
    }
    
    drzewo[ biez ] = wartosc;
}

/*
** szukaj
*/
TYP_DRZEWA *
szukaj( TYP_DRZEWA wartosc )
{
    int    biez;

    /*
    ** Rozpocznij od wza korzenia. Dopki nie odszukasz wartoci
    ** przejd do waciwego poddrzewa.
    */
    biez = 1;

    while( biez < ROZMIAR_TABLICY && drzewo[ biez ] != wartosc ){
        /*
        ** Przejd do lewego lub prawego poddrzewa, zgodnie z definicj.
        */
        if( wartosc < drzewo[ biez ] )
            biez = lewe_dziecko( biez );
        else
            biez = prawe_dziecko( biez );
    }
    
    if( biez < ROZMIAR_TABLICY )
        return drzewo + biez;
    else
        return 0;
}

/*
** wyk_przeszukiwanie_wzdluz
**    Zrealizuj jeden poziom przeszukiwania wzdu. Ta funkcja pomocnicza 
**    jest potrzebna do zapamitywania informacji na temat wanie 
**    przetwarzanego wza; nie jest to cz interfejsu klienta.
*/
static void
wyk_przeszukiwanie_wzdluz( int biez,
    void (*wywolanie)( TYP_DRZEWA wartosc ) )
{
    if( biez < ROZMIAR_TABLICY && drzewo[ biez ] != 0 ){
        wywolanie( drzewo[ biez ] );
        wyk_przeszukiwanie_wzdluz( lewe_dziecko( biez ),
            wywolanie );
        wyk_przeszukiwanie_wzdluz( prawe_dziecko( biez ),
            wywolanie );
    }
}

/*
** przeszukiwanie_wzdluz
*/
void
przeszukiwanie_wzdluz( void (*wywolanie)( TYP_DRZEWA wartosc ) )
{
    wyk_przeszukiwanie_wzdluz( 1, wywolanie );
}
