/*
** OGLNA implementacja stosu w tablicy statycznej . Rozmiar tablicy
** jest podany jako jeden z argumentw podczas tworzenia stosu.
*/
#include <assert.h>

#define    OGOLNY_STOS( TYP_STOSU, PRZYROSTEK, ROZMIAR_STOSU )   \
                                                                 \
    static    TYP_STOSU    stos##PRZYROSTEK[ ROZMIAR_STOSU ];    \
    static    int          g_element##PRZYROSTEK = -1;           \
                                                                 \
    int                                                          \
    pusty##PRZYROSTEK( void )                                    \
    {                                                            \
        return g_element##PRZYROSTEK == -1;                      \
    }                                                            \
                                                                 \
    int                                                          \
    pelny##PRZYROSTEK( void )                                    \
    {                                                            \
        return g_element##PRZYROSTEK == ROZMIAR_STOSU - 1;       \
    }                                                            \
                                                                 \
    void                                                         \
    push##PRZYROSTEK( TYP_STOSU wartosc )                        \
    {                                                            \
        assert( !pelny##PRZYROSTEK() );                          \
        g_element##PRZYROSTEK += 1;                              \
        stos##PRZYROSTEK[ g_element##PRZYROSTEK ] = wartosc;     \
    }                                                            \
                                                                 \
    void                                                         \
    pop##PRZYROSTEK( void )                                      \
    {                                                            \
        assert( !pusty##PRZYROSTEK() );                          \
        g_element##PRZYROSTEK -= 1;                              \
    }                                                            \
                                                                 \
    TYP_STOSU top##PRZYROSTEK( void )                            \
    {                                                            \
        assert( !pusty##PRZYROSTEK() );                          \
        return stos##PRZYROSTEK[ g_element##PRZYROSTEK ];        \
    }
