/*
** Stos implementowany za pomoca listy jednokierunkowej. Stos ten nie ma 
** ograniczenia wielkoci.
*/
#include "stos.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <assert.h>

#define    FALSE 0

/*
**    Definiowanie struktury do przechowywania jednej wartoci.
**    Pole czce wskazuje na nastpn warto na stosie.
*/
typedef    struct    WEZEL_STOSU {
    TYP_STOSU            wartosc;
    struct WEZEL_STOSU   *nast;
} WezelStosu;

/*
**    Wskanik do grnego wza na stosie.
*/
static    WezelStosu    *stos;

/*
**    tworz_stos
*/
void
tworz_stos( size_t rozmiar )
{
}

/*
**    usun_stos
*/
void
usun_stos( void )
{
    while( !pusty() )
        pop();
}

/*
**    push
*/
void
push( TYP_STOSU wartosc )
{
    WezelStosu    *nowy_wezel;

    nowy_wezel = malloc( sizeof( WezelStosu ) );
    assert( nowy_wezel != NULL );
    nowy_wezel->wartosc = wartosc;
    nowy_wezel->nast = stos;
    stos = nowy_wezel;
}

/*
**    pop
*/
void
pop( void )
{
    WezelStosu    *pierwszy_wezel;

    assert( !pusty() );
    pierwszy_wezel = stos;
    stos = pierwszy_wezel->nast;
    free( pierwszy_wezel );
}

/*
**    top
*/
TYP_STOSU top( void )
{
    assert( !pusty() );
    return stos->wartosc;
}

/*
**    pusty
*/
int
pusty( void )
{
    return stos == NULL;
}

/*
**    pelny
*/
int
pelny( void )
{
    return FALSE;
}
