/*
** Stos implementowany z uyciem tablicy przydzielanej dynamicznie.
** Rozmiar jest podawany podczas tworzenia tablicy. Wyoanie to 
** musi nastpi przed wykonaniem jakichkolwiek operacji na stosie.
*/
#include "stos.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <assert.h>

/*
**    Tablica przechowujca wartoci stosu oraz wskanik do 
**    wartoci na szczycie stosu.
*/
static    TYP_STOSU    *stos;
static    size_t       rozmiar_stosu;
static    int          g_element = -1;

/*
**    tworz_stos
*/
void
tworz_stos( size_t rozmiar )
{
    assert( rozmiar_stosu == 0 );
    rozmiar_stosu = rozmiar;
    stos = malloc( rozmiar_stosu * sizeof( TYP_STOSU ) );
    assert( stos != NULL );
}

/*
**    usun_stos
*/
void
usun_stos( void )
{
    assert( rozmiar_stosu > 0 );
    rozmiar_stosu = 0;
    free( stos );
    stos = NULL;
}

/*
**    push
*/
void
push( TYP_STOSU wartosc )
{
    assert( !pelny() );
    g_element += 1;
    stos[ g_element ] = wartosc;
}

/*
**    pop
*/
void
pop( void )
{
    assert( !pusty() );
    g_element -= 1;
}

/*
**    top
*/
TYP_STOSU top( void )
{
    assert( !pusty() );
    return stos[ g_element ];
}

/*
**    pusty
*/
int
pusty( void )
{
    assert( rozmiar_stosu > 0 );
    return g_element == -1;
}

/*
**    pelny
*/
int
pelny( void )
{
    assert( rozmiar_stosu > 0 );
    return g_element == rozmiar_stosu - 1;
}
