/*
** Uycie liczb losowych w celu przetasowania kart w talii. Drugi
** argument wskazuje liczb kart. Za pierwszym wywoaniem tej funkcji,
** wywoywana jest funkcja srand w celu inicjalizacji generatora
** liczb losowych.
*/
#include <stdlib.h>
#include <time.h>
#define    TRUE    1
#define    FALSE   0

void tasuj( int *talia, int il_kart )
{
    int    i;
    static    int    pierwszy_raz = TRUE;

    /*
    ** Inicjalizacja generatora liczb losowych biec godzin
    ** i dat, jeli nie zostao to jeszcze zrobione.
    */
    if( pierwszy_raz ){
        pierwszy_raz = FALSE;
        srand( (unsigned int)time( NULL ) );
    }

    /*
    ** "tasowanie" poprzez zamian miejscami losowych par kart.
    */
    for( i = il_kart - 1; i > 0; i -= 1 ){
        int    gdzie;
        int    temp;

        gdzie = rand() % i;
        temp = talia[ gdzie ];
        talia[ gdzie ] = talia[ i ];
        talia[ i ] = temp;
    }
}
