/*
** Wstawianie do uporzdkowanej listy jednokierunkowej. Argumentami
** s: wskanik do wskanika korzenia listy i warto do wstawienia.
*/
#include <stdlib.h>
#include <stdio.h>
#include "wezel_poj.h"

#define    FALSE    0
#define    TRUE    1

int
wstaw_lista_poj( Wezel **korzen_wsk, int nowa_wart )
{
    Wezel    *biez;
    Wezel    *poprzedni;
    Wezel    *nowy;

    /*
    ** Pobranie wskanika do piewszego wza.
    */
    biez = *korzen_wsk;
    poprzedni = NULL;

    /*
    ** Szukanie waciwego miejsca poprzez przegldanie listy
    ** do momentu znalezienia wza, ktrego warto jest wiksza
    ** lub rwna nowej wartoci.
    */
    while( biez != NULL && biez->wartosc < nowa_wart ){
        poprzedni = biez;
        biez = biez->polaczenie;
    }

    /*
    ** Utworzenie nowego wza i zapamitanie w nim nowej wartoci.
    ** W przypadku niepowodzenia, zwracana jest warto FALSE.
    */
    nowy = (Wezel *)malloc( sizeof( Wezel ) );
    if( nowy == NULL )
        return FALSE;
    nowy->wartosc = nowa_wart;

    /*
    ** Wstawienie nowego wza do listy i zwrcenie TRUE.
    */
    nowy->polaczenie = biez;
    if( poprzedni == NULL )
        *korzen_wsk = nowy;
    else
        poprzedni->polaczenie = nowy;
    return TRUE;
}
