/*
** Odczyt, sortowanie i drukowanie listy wartoci cakowitych.
*/
#include <stdlib.h>
#include <stdio.h>

/*
**    Funkcja wywoywana przez 'qsort' do porwnywania wartoci cakowitych
*/
int
porownaj_int( void const *a, void const *b )
{
    register int    const *pa = a;
    register int    const *pb = b;

    return *pa > *pb ? 1 : *pa < *pb ? -1 : 0;
}

int
main()
{
    int    *tablica;
    int    il_wartosci;
    int    i;

    /*
    ** Pobranie ilosci liczb.
    */
    printf( "Ile wartoci zostanie podanych? " );
    if( scanf( "%d", &il_wartosci ) != 1 || il_wartosci <= 0 ){
        printf( "Nieprawidowa liczba wartoci.\n" );
        exit( EXIT_FAILURE );
    }

    /*
    ** Pobranie pamici do ich zapamitania.
    */
    tablica = malloc( il_wartosci * sizeof( int ) );
    if( tablica == NULL ){
        printf( "Nie mona przydzieli pamici na tyle wartoci.\n" );
        exit( EXIT_FAILURE );
    }

    /*
    ** Odczyt liczb.
    */
    for( i = 0; i < il_wartosci; i += 1 ){
        printf( "? " );
        if( scanf( "%d", tablica + i ) != 1 ){
            printf( "Bd odczytu wartoci #%d\n", i );
            exit( EXIT_FAILURE );
        }
    }

    /*
    ** Sortowanie wartoci.
    */
    qsort( tablica, il_wartosci, sizeof( int ), porownaj_int );

    /*
    ** Drukowanie posortowanych liczb.
    */
    for( i = 0; i < il_wartosci; i += 1 )
        printf( "%d\n", tablica[i] );

    /*
    ** Zwolnienie pamici i koniec.
    */
    free( tablica );
    return EXIT_SUCCESS;
}
