/*
** Funkcja tworzca rekord magazynowy PODZESPOU.
*/

#include <stdlib.h>
#include <stdio.h>
#include "magazyn.h"

Rek_magaz *
tworz_rekord_podzespol( int il_czesci )
{
    Rek_magaz    *nowy_rekord;

    /*
    ** Prba przydzielenia pamici na cz Rek_magaz.
    */
    nowy_rekord = malloc( sizeof( Rek_magaz ) );
    if( nowy_rekord != NULL ){
        /*
        ** Udao si; teraz przydzielamy cz PODZESPOL_INFO.
        */
        nowy_rekord->info.podzespol =
            malloc( sizeof( Podzespol_info ) );
        if( nowy_rekord->info.podzespol != NULL ){
            /*
            ** Utworzenie odpowiednio duej tablicy na czci.
            */
            nowy_rekord->info.podzespol->czesc = malloc(
                il_czesci * sizeof( struct PODZESPOL_INFO ) );
            if( nowy_rekord->info.podzespol->czesc != NULL ){
                /*
                ** Udao si przydzieli pami; wypeniamy pola znanymi
                **  wartociami i zwracamy gotowy rekord.
                */
                nowy_rekord->typ = PODZESP;
                nowy_rekord->info.podzespol->il_czesci =
                    il_czesci;
                return nowy_rekord;
            }

            /*
            ** Brak pamici: zwalniamy to, co udao si do tej pory przydzieli
            */
            free( nowy_rekord->info.podzespol );
        }
        free( nowy_rekord );
    }
    return NULL;
}
