/*
** Program ten odczytuje wiersze wejciowe ze standardowego wejcia i drukuje
** kady wiersz wejciowy, poprzedzony cigiem opisu, na standardowe wyjcie.
**
** Pierwszy wiersz wejciowy stanowi list numerw kolumn, ktre kocz si 
** liczb ujemn. Numery kolumn s parami okrelajcymi zakresy kolumn
** z wierszy wejciowych, ktre bd drukowane przez program.
** Na przykad, 0 3 10 12 -1 wskazuje, e tylko kolumny od 0 do 3 
** i kolumny od 10 do 12 zostan wydrukowane.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define  MAX_L_KOLUMN  20  /* maksymalna liczba przetwarzanych kolumn */
#define  MAX_L_WIERSZY  1000  /* maks. liczba wierszy wejciowych*/

int  czytaj_zakresy_kolumn( int kolumny[], int maks );
void przeksztalc( char *wyjscie, char const *wejscie,
      int l_kolumn, int const kolumny[] );

int
main( void )
{
  int  l_kolumn;                 /* ilo kolumn do przetworzenia */
  int  kolumny[MAX_L_KOLUMN];    /* kolumny do przetworzenia */
  char  wejscie[MAX_L_WIERSZY];  /* tablica wierszy wejciowych */
  char  wyjscie[MAX_L_WIERSZY];  /* tablica wierszy wyjciowych */

  /*
  ** Odczyt listy zakresw kolumn
  */
  l_kolumn = czytaj_zakresy_kolumn( kolumny, MAX_L_KOLUMN );

  /*
  ** Odczytanie, przetworzenie i wydrukowanie pozostaych wierszy wejciowych
  */
  while( gets( wejscie ) != NULL ){
    printf( "Dane wejciowe       : %s\n", wejscie );
    przeksztalc( wyjscie, wejscie, l_kolumn, kolumny );
    printf( "Przeksztacony wiersz: %s\n", wyjscie );
  }

  return EXIT_SUCCESS;
}

/*
** Odczytanie listy zakresw kolumn, ignorujc wykraczajce poza zaoone
** maksimum.
*/
int
czytaj_zakresy_kolumn( int kolumny[], int maks )
{
  int  num = 0;
  int  zn;

  /*
  ** Pobranie liczb, zatrzymujc si na kocu pliku lub, gdy liczba jest < 0.
  */
  while( num < maks && scanf( "%d", &kolumny[num] ) == 1
      && kolumny[num] >= 0 )
    num += 1;

  /*
  ** Upewnienie si, e odczytano parzyst liczb wierszy, poniewa
  ** oczekuje si par w danych wejciowych.
  */
  if( num % 2 != 0 ){
    puts( "Zakres ostatniej kolumny nie ma pary." );
    exit( EXIT_FAILURE );
  }

  /*
  ** Opuszczenie reszty wiersza po ostatniej liczbie.
  */
  while( (zn = getchar()) != EOF && zn != '\n' )
    ;

  return num;
}

/*
** Przetwarzanie wiersza wejciowego przez czenie znakw z wczytanych kolumn
** Wiersz wyjciowy jest zakoczony znakiem NUL.
*/
void
przeksztalc( char *wyjscie, char const *wejscie,
    int l_kolumn, int const kolumny[] )
{
  int  kol;      /* indeks kolumny w tablicy */
  int  kol_wyj;  /* licznik kolumn wyjciowych */
  int  dlugosc;  /* dugo wiersza wejciowego */

  dlugosc = strlen( wejscie );
  kol_wyj = 0;

  /*
  ** Przetwarzanie kadej pary zakresw kolumn.
  */
  for( kol = 0; kol < l_kolumn; kol += 2 ){
    int  il_znakow = kolumny[kol + 1] - kolumny[kol] + 1;

    /*
    ** Jeeli wiersz wejciowy jest wystarczajco dugi lub tablica wyjciowa
    ** jest zapeniona, koczymy.
    */
    if( kolumny[kol] >= dlugosc ||
        kol_wyj == MAX_L_WIERSZY - 1 )
      break;

    /*
    ** Jeeli nie ma miejsca w tablicy wyjciowej, kopiujemy tylko 
    ** to, co si zmieci.
    */
    if( kol_wyj + il_znakow > MAX_L_WIERSZY - 1 )
      il_znakow = MAX_L_WIERSZY - kol_wyj - 1;

    /*
    ** Kopiowanie odpowiednich danych.
    */
    strncpy( wyjscie + kol_wyj, wejscie + kolumny[kol],
        il_znakow );
    kol_wyj += il_znakow;
  }

  wyjscie[kol_wyj] = '\0';
}
