/*
** Konwersja cigu cyfr 'zrodlo' na posta zotwek i groszy oraz 
** zapamitanie ich w 'cel'.
*/

#include <stdio.h>

void
zlotowki( register char *cel, register char const *zrodlo )
{
        int        dlugosc;

        if( cel == NULL || zrodlo == NULL )
                return;

        dlugosc = strlen( zrodlo );

        /*
        ** Jeeli cig cyfr jest wystarczajco dugi, skopiuj cyfry, kre znajd
        ** si po lewej stronie przecinka dziesitnego, umieszczajc odstpy
        ** w odpowiednich miejscach. Jeeli cig jest krtszy ni 3 cyfry
        ** wymu '0' przed przecinkiem.
        */
        if( dlugosc >= 3 ){
                int        i;

                for( i = dlugosc - 2; i > 0; ){
                        *cel++ = *zrodlo++;
                        if( --i > 0 && i % 3 == 0 )
                                *cel++ = ' ';
                }
        } else
                *cel++ = '0';

        /*
        ** Zapisz przecinek dziesitny i pozostae cyfry
        ** z 'zrodlo'. Jeeli 'zrodlo' ma mniej ni dwie cyfry,
        ** wymu dopisanie '0'. Nastpnie dopisz symbol ' z' 
        ** i kocowy bajt NUL.
        */
        *cel++ = ',';
        *cel++ = dlugosc < 2 ? '0' : *zrodlo++;
        *cel++ = dlugosc < 1 ? '0' : *zrodlo;
        *cel++ = ' ';
        *cel++ = 'z';
        *cel++ = '';
        *cel = 0;
}

