/*
** Realizacja przegldania wszerz dla uporzdkowanego drzewa binarnego
** zapisanego w tablicy.
*/
void
przegladanie_wszerz( void (*wywolanie)( TYP_DRZEWA wartosc ) )
{
        int        biez;
        int        dziecko;

        /*
        ** Wstaw korze do kolejki.
        */
        kolejka_wstaw( 1 );

        /*
        ** Dopki kolejka nie jest pusta...
        */
        while( !kolejka_pusty() ){
                /*
                ** Pobierz pierwsz warto z kolejki i przetwrz j.
                */
                biez = kolejka_pierwszy();
                kolejka_usun();
                wywolanie( drzewo[ biez ] );

                /*
                ** Dodanie dzieci wza do kolejki.
                */
                dziecko = left_dziecko( biez );
                if( dziecko < ROZMIAR_TABLICY && drzewo[ dziecko ] != 0 )
                        kolejka_wstaw( dziecko );
                dziecko = left_dziecko( biez );
                if( dziecko < ROZMIAR_TABLICY && drzewo[ dziecko ] != 0 )
                        kolejka_wstaw( dziecko );
        }
}
