/*
** Testowanie losowoci wartoci zwracanych przez rand.
*/

#include <stdlib.h>
#include <stdio.h>

/*
**        Tablice do zliczania wzgldnej czstotliwoci rnych liczb.
*/
int        czestotliwosc2[2];
int        czestotliwosc3[3];
int        czestotliwosc4[4];
int        czestotliwosc5[5];
int        czestotliwosc6[6];
int        czestotliwosc7[7];
int        czestotliwosc8[8];
int        czestotliwosc9[9];
int        czestotliwosc10[10];

/*
**        Tablice do zliczania cyklicznej czstotliwoci rnych liczb.
*/
int        cykl2[2][2];
int        cykl3[3][3];
int        cykl4[4][4];
int        cykl5[5][5];
int        cykl6[6][6];
int        cykl7[7][7];
int        cykl8[8][8];
int        cykl9[9][9];
int        cykl10[10][10];


/*
**        Makro zliczajce czstotliwo wzgldn i cykliczn dla 
**        podanej liczby.
*/
#define        SPRAWDZ( liczba, tablica_cz, tablica_cykl )        \
                reszta = x % liczba;                              \
                tablica_cz[ reszta ] += 1;                        \
                tablica_cykl[ reszta ][ ost_x % liczba ] += 1

/*
**        Makro do drukowania tabeli czstotliwoci.
*/
#define        DRUK_CZ( liczba, tablica_cz )                       \
        printf( "\nCzstotliwo liczb losowych modulo %d\n\t",    \
            liczba );                                              \
        for( i = 0; i < liczba; i += 1 )                           \
                printf( " %5d", tablica_cz[ i ] );                 \
        printf( "\n" )

/*
**        Makro do drukowania tabeli czstotliwoci cyklicznej.
*/
#define DRUK_CYKL( liczba, tablica_cykl )                               \
        printf( "\nCykliczna czstotliwo liczb losowych modulo %d\n", \
            liczba );                                                   \
        for( i = 0; i < liczba; i += 1 ){                               \
                printf( "\t" );                                         \
                for( j = 0; j < liczba; j += 1 )                        \
                        printf( " %5d", tablica_cykl[ i ][ j ] );       \
                printf( "\n" );                                         \
        }


int
main( int ac, char **av )
{
        int        i;
        int        j;
        int        x;
        int        ost_x;
        int        reszta;

        /*
        ** Jeeli podane zostao ziarno, zainicjuj generator.
        */
        if( ac > 1 )
                srand( atoi( av[ 1 ] ) );

        ost_x = rand();

        /*
        ** Uruchom testy.
        */
        for( i = 0; i < 10000; i += 1 ){
                x = rand();
                SPRAWDZ( 2, czestotliwosc2, cykl2 );
                SPRAWDZ( 3, czestotliwosc3, cykl3 );
                SPRAWDZ( 4, czestotliwosc4, cykl4 );
                SPRAWDZ( 5, czestotliwosc5, cykl5 );
                SPRAWDZ( 6, czestotliwosc6, cykl6 );
                SPRAWDZ( 7, czestotliwosc7, cykl7 );
                SPRAWDZ( 8, czestotliwosc8, cykl8 );
                SPRAWDZ( 9, czestotliwosc9, cykl9 );
                SPRAWDZ( 10, czestotliwosc10, cykl10 );
                ost_x = x;
        }

        /*
        ** Drukuj wyniki.
        */
        DRUK_CZ( 2, czestotliwosc2 );
        DRUK_CZ( 3, czestotliwosc3 );
        DRUK_CZ( 4, czestotliwosc4 );
        DRUK_CZ( 5, czestotliwosc5 );
        DRUK_CZ( 6, czestotliwosc6 );
        DRUK_CZ( 7, czestotliwosc7 );
        DRUK_CZ( 8, czestotliwosc8 );
        DRUK_CZ( 9, czestotliwosc9 );
        DRUK_CZ( 10, czestotliwosc10 );

        DRUK_CYKL( 2, cykl2 );
        DRUK_CYKL( 3, cykl3 );
        DRUK_CYKL( 4, cykl4 );
        DRUK_CYKL( 5, cykl5 );
        DRUK_CYKL( 6, cykl6 );
        DRUK_CYKL( 7, cykl7 );
        DRUK_CYKL( 8, cykl8 );
        DRUK_CYKL( 9, cykl9 );
        DRUK_CYKL( 10, cykl10 );

        return EXIT_SUCCESS;
}
