/*
** Usuwa podany wze z listy pojedynczej. Pierwszy argument wskazuje
** na wskanik korzenia listy, natomiast drugi wskazuje na wze do usunicia.
** Jeeli usunicie si udao, funkcja zwraca TRUE, w przeciwnym razie FALSE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "wezel_poj.h"

#define        FALSE       0
#define        TRUE        1

int
int lpoj_usun( struct WEZEL **wsk_korzen, struct WEZEL *wezel )
{
        register Wezel        *biez;

        assert( wezel != NULL );

        /*
        ** Wyszukaj wskazany wze.
        */
        while( ( biez = *wsk_korzen ) != NULL && biez != wezel )
                wsk_korzen = &biez->polaczenie;

        if( biez == wezel ){
                *wsk_korzen = biez->polaczenie;
                free( biez );
                return TRUE;
        }
        else 
                return FALSE;
}
