/*
** Odczytuje ze standardowego wejcia list liczb cakowitych zakoczon 
** znakiem EOF i zwraca dynamicznie przydzielon tablic zawierajc 
** te wartoci. Pierwszy element tablicy zawiera liczb wartoci 
** zapisanych w tablicy.
*/

#include <stdio.h>
#include <malloc.h>

#define        DELTA                100

int *
czyt_int()
{
        int        *tablica;
        int        rozmiar;
        int        licznik;
        int        wartosc;

        /*
        ** Przydziel pocztkow tablic, ktra mieci DELTA wartoci.
        */
        rozmiar = DELTA;
        tablica = malloc( ( rozmiar + 1 ) * sizeof( int ) );
        if( tablica == NULL )
                return NULL;

        /*
        ** Pobieraj wartoci ze standardowego wejcia.
        */
        licznik = 0;
        while( scanf( "%d", &wartosc ) == 1 ){
                /*
                ** Powiksz w razie potrzeby tablic i zapamitaj warto.
                */
                licznik += 1;
                if( licznik > rozmiar ){
                        rozmiar += DELTA;
                        tablica = realloc( tablica,
                            ( rozmiar + 1 ) * sizeof( int ) );
                        if( tablica == NULL )
                                return NULL;
                }
                tablica[ licznik ] = wartosc;
        }

        /*
        ** Zmie wielko tablicy na waciw, nastpnie zapamitaj licznik
        ** i zwr tablic. Nie nastpuje tu powikszenie tablicy, 
        ** wic nie powinien wystpi bd (sprawdmy to na wszelki wypadek).
        */
        if( licznik < rozmiar ){
                tablica = realloc( tablica,
                    ( licznik + 1 ) * sizeof( int ) );
                if( tablica == NULL )
                        return NULL;
        }
        tablica[ 0 ] = licznik;
        return tablica;
}
