#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DEFAULT_SIZE 100
#define true 1
#define false 0
// w[0] - wysokość 1 macierzy
// w[1] - szerokość 1 macierzy i jednocześnie wysokość drugiej
// w[2] szerokość 2 macierzy
//funkcja generująca macierze
int **tabCreate(int y, int x, int losuj) {
	int **a,i,i2;
	a = (int **)malloc(sizeof(int *)*y);//przydzielenie pamięci dla jednego wymiaru
	for(i=0;i<y;i++) {
		a[i] = (int *)malloc(sizeof(int)*x);//przydzielenie pamięci dla drugiego wymiaru
		if(losuj) {
			for(i2=0;i2<x;i2++) a[i][i2] = rand()%10;//generowanie elementów
		}	else for(i2=0;i2<x;i2++) a[i][i2] = 0;
	}
return a;
}
//funkcja wyliczająca różnicę między dwoma czasami
long long int toddiff(struct timeval *tod1, struct timeval *tod2)
{
    long long t1, t2;
    t1 = tod1->tv_sec * 1000000 + tod1->tv_usec;
    t2 = tod2->tv_sec * 1000000 + tod2->tv_usec;
    return t1 - t2;
}

int main( int argc, char *argv[])
{
int **a, **b, **c; //deklaracja 3 tablic
int i,j,k;
struct timeval tod1, tod2;
int temp;
int w[3];

srand(time(NULL));

for(i=0;i<3;i++) {
	if(argc>=2+i) {
		temp = 0;
		sscanf(argv[1+i],"%d",&temp);
		if(temp>0) w[i] = temp;
		else {
			w[i] = DEFAULT_SIZE;
		}	
	}
	else {
			w[i] = DEFAULT_SIZE;
		}	
		printf("arg[%d] = %d\n", i,w[i]);
}
//utworzenie 3 macierzy
a = tabCreate(w[0],w[1],true);
b = tabCreate(w[1],w[2],true);
c = tabCreate(w[0],w[2],false);

printf("Start\n");
gettimeofday(&tod1, NULL);
//------------------------

for(i=0;i<w[0];i++){

	for(j=0;j<w[2];j++) {
		for(k=0;k<w[1];k++) {
			c[i][j] += a[i][k]*b[k][j];
		}
	}
}

//------------------------
gettimeofday(&tod2, NULL);
//zwalnianie pamięci
for(i=0;i<w[0];i++) {
	free(c[i]);
	free(a[i]);
}

for(i=0;i<w[1];i++) {
	free(b[i]);
}

free(a);
free(a);
free(b);
free(c);

printf("Czas: %ld milisekund\n",(long int)(toddiff(&tod2, &tod1) / 1000.0));

return 0;
}

