/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.plaf.UIManager;

public final class CommonTransitions
extends Transition {
    private Motion motion;
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_SLIDE = 1;
    private static final int TYPE_FADE = 2;
    private static final int TYPE_FAST_SLIDE = 3;
    public static final int SLIDE_HORIZONTAL = 0;
    public static final int SLIDE_VERTICAL = 1;
    private int slideType;
    private int speed;
    private int position;
    private int transitionType;
    private Image buffer;
    private Image secondaryBuffer;
    private static boolean defaultLinearMotion = false;
    private boolean linearMotion = defaultLinearMotion;
    private boolean motionSetManually;
    private RGBImage rgbBuffer;
    private boolean forward;
    private boolean drawDialogMenu;
    private boolean firstFinished;

    private CommonTransitions(int type) {
        this.transitionType = type;
    }

    public static CommonTransitions createEmpty() {
        CommonTransitions t = new CommonTransitions(0);
        return t;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration) {
        return CommonTransitions.createFastSlide(type, forward, duration, false);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration) {
        return CommonTransitions.createSlide(type, forward, duration, false);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(1);
        t.slideType = type;
        t.forward = forward;
        if (type == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            t.forward = !t.forward;
        }
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(3);
        t.slideType = type;
        t.forward = forward;
        if (type == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            t.forward = !t.forward;
        }
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createFade(int duration) {
        CommonTransitions t = new CommonTransitions(2);
        t.speed = duration;
        return t;
    }

    public void initTransition() {
        this.firstFinished = false;
        if (this.transitionType == 0) {
            return;
        }
        Component source = this.getSource();
        Component destination = this.getDestination();
        this.position = 0;
        int w = source.getWidth();
        int h = source.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = Image.createImage(w, h);
        } else if (this.buffer.getWidth() != w || this.buffer.getHeight() != h) {
            this.buffer = Image.createImage(w, h);
            this.rgbBuffer = null;
            this.motion = null;
        }
        if (this.transitionType == 2) {
            this.motion = this.createMotion(0, 256, this.speed);
            this.motion.start();
            Graphics g = this.buffer.getGraphics();
            g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
            if (this.getSource().getParent() != null) {
                this.getSource().getComponentForm().paintComponent(g);
            }
            g.setClip(0, 0, this.buffer.getWidth() + source.getAbsoluteX(), this.buffer.getHeight() + source.getAbsoluteY());
            this.paint(g, this.getDestination(), 0, 0);
            if (g.isAlphaSupported()) {
                this.secondaryBuffer = this.buffer;
                this.buffer = Image.createImage(w, h);
            } else {
                this.rgbBuffer = new RGBImage(this.buffer.getRGBCached(), this.buffer.getWidth(), this.buffer.getHeight());
            }
            this.paint(g, this.getSource(), 0, 0);
            g.translate(source.getAbsoluteX(), source.getAbsoluteY());
        } else if (this.transitionType == 1 || this.transitionType == 3) {
            int dest;
            int startOffset = 0;
            if (this.slideType == 0) {
                dest = w;
                if (destination instanceof Dialog) {
                    startOffset = w - ((Dialog)destination).getContentPane().getWidth();
                    startOffset = this.forward ? (startOffset -= ((Dialog)destination).getContentPane().getStyle().getMargin(destination.isRTL(), 1)) : (startOffset -= ((Dialog)destination).getContentPane().getStyle().getMargin(destination.isRTL(), 3));
                } else if (source instanceof Dialog) {
                    dest = ((Dialog)source).getContentPane().getWidth();
                    dest = this.forward ? (dest += ((Dialog)source).getContentPane().getStyle().getMargin(source.isRTL(), 1)) : (dest += ((Dialog)source).getContentPane().getStyle().getMargin(source.isRTL(), 3));
                }
            } else {
                Container p;
                dest = h;
                if (destination instanceof Dialog) {
                    startOffset = h - ((Dialog)destination).getContentPane().getHeight() - ((Dialog)destination).getTitleComponent().getHeight();
                    if (this.forward) {
                        startOffset -= ((Dialog)destination).getContentPane().getStyle().getMargin(false, 2);
                    } else {
                        startOffset -= ((Dialog)destination).getContentPane().getStyle().getMargin(false, 0);
                        startOffset -= ((Dialog)destination).getTitleStyle().getMargin(false, 0);
                        if (!this.drawDialogMenu && ((Dialog)destination).getCommandCount() > 0 && (p = ((Dialog)destination).getSoftButton(0).getParent()) != null) {
                            startOffset -= p.getHeight();
                        }
                    }
                } else if (source instanceof Dialog) {
                    dest = ((Dialog)source).getContentPane().getHeight() + ((Dialog)source).getTitleComponent().getHeight();
                    if (this.forward) {
                        dest += ((Dialog)source).getContentPane().getStyle().getMargin(false, 2);
                    } else {
                        dest += ((Dialog)source).getContentPane().getStyle().getMargin(false, 0);
                        dest += ((Dialog)source).getTitleStyle().getMargin(false, 0);
                        if (((Dialog)source).getCommandCount() > 0 && (p = ((Dialog)source).getSoftButton(0).getParent()) != null) {
                            dest += p.getHeight();
                        }
                    }
                }
            }
            this.motion = this.createMotion(startOffset, dest, this.speed);
            Graphics g = this.buffer.getGraphics();
            if (this.getSource() instanceof Dialog) {
                this.paint(g, this.getDestination(), 0, 0);
                if (this.transitionType == 3 && !(destination instanceof Dialog)) {
                    Dialog d = (Dialog)source;
                    this.secondaryBuffer = Image.createImage(d.getContentPane().getWidth(), d.getContentPane().getHeight() + d.getTitleComponent().getHeight());
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else if (this.getDestination() instanceof Dialog) {
                this.paint(g, this.getSource(), 0, 0);
                if (this.transitionType == 3 && !(source instanceof Dialog)) {
                    Dialog d = (Dialog)destination;
                    this.secondaryBuffer = Image.createImage(d.getContentPane().getWidth(), d.getContentPane().getHeight() + d.getTitleComponent().getHeight());
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else {
                this.paint(g, source, -source.getAbsoluteX(), -source.getAbsoluteY());
                if (this.transitionType == 3) {
                    this.secondaryBuffer = Image.createImage(destination.getWidth(), destination.getHeight());
                    this.paint(this.secondaryBuffer.getGraphics(), destination, -destination.getAbsoluteX(), -destination.getAbsoluteY());
                }
            }
            this.motion.start();
        }
    }

    protected Motion createMotion(int startOffset, int dest, int speed) {
        if (this.motionSetManually) {
            return this.motion;
        }
        if (this.linearMotion) {
            return Motion.createLinearMotion(startOffset, dest, speed);
        }
        return Motion.createSplineMotion(startOffset, dest, speed);
    }

    public boolean animate() {
        if (this.motion == null) {
            return false;
        }
        this.position = this.motion.getValue();
        if (this.firstFinished) {
            return false;
        }
        boolean finished = this.motion.isFinished();
        if (finished && !this.firstFinished) {
            this.firstFinished = true;
        }
        return true;
    }

    public void paint(Graphics g) {
        try {
            switch (this.transitionType) {
                case 1: {
                    if (this.slideType == 0) {
                        this.paintSlideAtPosition(g, this.position, 0);
                    } else {
                        this.paintSlideAtPosition(g, 0, this.position);
                    }
                    return;
                }
                case 3: {
                    if (this.slideType == 0) {
                        this.paintFastSlideAtPosition(g, this.position, 0);
                    } else {
                        this.paintFastSlideAtPosition(g, 0, this.position);
                    }
                    return;
                }
                case 2: {
                    this.paintAlpha(g);
                    return;
                }
            }
        }
        catch (Throwable t) {
            System.out.println("An exception occurred during transition paint this might be valid in case of a resize in the middle of a transition");
            t.printStackTrace();
        }
    }

    private void paintAlpha(Graphics graphics) {
        if (this.rgbBuffer != null || this.secondaryBuffer != null) {
            Component src = this.getSource();
            int w = src.getWidth();
            int h = src.getHeight();
            int position = this.position;
            if (position > 255) {
                position = 255;
            } else if (position < 0) {
                position = 0;
            }
            if (this.secondaryBuffer != null) {
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.setAlpha(position);
                graphics.drawImage(this.secondaryBuffer, x, y);
                graphics.setAlpha(255);
            } else {
                int alpha = position << 24;
                int size = w * h;
                int[] bufferArray = this.rgbBuffer.getRGB();
                for (int iter = 0; iter < size; ++iter) {
                    bufferArray[iter] = bufferArray[iter] & 0xFFFFFF | alpha;
                }
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.drawImage(this.rgbBuffer, x, y);
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        this.buffer = null;
        this.rgbBuffer = null;
        this.secondaryBuffer = null;
    }

    private void paintSlideAtPosition(Graphics g, int slideX, int slideY) {
        Component source = this.getSource();
        if (source == null) {
            return;
        }
        Component dest = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (this.slideType == 0) {
            h = 0;
        } else {
            w = 0;
        }
        if (this.forward) {
            w = -w;
            h = -h;
        } else {
            slideX = -slideX;
            slideY = -slideY;
        }
        g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
        if (source instanceof Dialog) {
            g.drawImage(this.buffer, 0, 0);
            this.paint(g, source, -slideX, -slideY);
            return;
        }
        if (dest instanceof Dialog) {
            g.drawImage(this.buffer, 0, 0);
            this.paint(g, dest, -slideX - w, -slideY - h);
            return;
        }
        if (source.getParent() != null) {
            source.paintBackgrounds(g);
            this.paint(g, source, slideX, slideY);
        } else {
            g.drawImage(this.buffer, slideX, slideY);
        }
        this.paint(g, dest, slideX + w, slideY + h);
    }

    private void paintFastSlideAtPosition(Graphics g, int slideX, int slideY) {
        if (this.secondaryBuffer != null) {
            Component source = this.getSource();
            if (source == null) {
                return;
            }
            Component dest = this.getDestination();
            int w = this.buffer.getWidth();
            int h = this.buffer.getHeight();
            if (this.slideType == 0) {
                h = 0;
            } else {
                w = 0;
            }
            if (this.forward) {
                w = -w;
                h = -h;
            } else {
                slideX = -slideX;
                slideY = -slideY;
            }
            g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
            if (source instanceof Dialog) {
                g.drawImage(this.buffer, 0, 0);
                g.drawImage(this.secondaryBuffer, -(slideX -= ((Dialog)source).getContentPane().getX()), -(slideY -= ((Dialog)source).getContentPane().getY()));
                return;
            }
            if (dest instanceof Dialog) {
                g.drawImage(this.buffer, 0, 0);
                g.drawImage(this.secondaryBuffer, -(slideX -= ((Dialog)dest).getTitleComponent().getX()) - w, -(slideY -= ((Dialog)dest).getTitleComponent().getY()) - h);
                return;
            }
            g.drawImage(this.buffer, slideX, slideY);
            g.drawImage(this.secondaryBuffer, slideX + w, slideY + h);
        } else {
            this.paintSlideAtPosition(g, slideX, slideY);
        }
    }

    private void drawDialogCmp(Graphics g, Dialog dlg) {
        Container menuBar;
        Painter p = dlg.getStyle().getBgPainter();
        dlg.getStyle().setBgPainter(null);
        g.translate(-dlg.getTitleComponent().getX(), -dlg.getTitleComponent().getY());
        dlg.getTitleComponent().paintComponent(g, false);
        g.translate(dlg.getTitleComponent().getX(), dlg.getTitleComponent().getY());
        g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
        g.translate(-dlg.getContentPane().getX(), -dlg.getContentPane().getY() + dlg.getTitleComponent().getHeight());
        dlg.getContentPane().paintComponent(g, false);
        if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
            g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
            menuBar.paintComponent(g, false);
        }
        dlg.getStyle().setBgPainter(p);
    }

    private void paint(Graphics g, Component cmp, int x, int y) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (cmp instanceof Dialog) {
            if (!(this.transitionType == 2 || this.getSource() instanceof Dialog && this.getDestination() instanceof Dialog && cmp == this.getDestination())) {
                Container menuBar;
                Painter p = cmp.getStyle().getBgPainter();
                cmp.getStyle().setBgPainter(null);
                g.translate(x, y);
                Dialog dlg = (Dialog)cmp;
                g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                dlg.getTitleComponent().paintComponent(g, false);
                g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                dlg.getContentPane().paintComponent(g, false);
                g.translate(-x, -y);
                if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
                    g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                    menuBar.paintComponent(g, false);
                }
                g.setClip(cx, cy, cw, ch);
                cmp.getStyle().setBgPainter(p);
                return;
            }
            cmp.paintComponent(g, false);
            return;
        }
        g.translate(x, y);
        cmp.paintComponent(g, false);
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
    }

    public Motion getMotion() {
        return this.motion;
    }

    public void setMotion(Motion motion) {
        this.motionSetManually = true;
        this.motion = motion;
    }

    public Transition copy(boolean reverse) {
        CommonTransitions retVal = null;
        switch (this.transitionType) {
            case 2: {
                retVal = CommonTransitions.createFade(this.speed);
                break;
            }
            case 1: {
                boolean fwd = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl = fwd = !fwd;
                }
                if (reverse) {
                    retVal = CommonTransitions.createSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 3: {
                boolean fwd = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl = fwd = !fwd;
                }
                if (reverse) {
                    retVal = CommonTransitions.createFastSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createFastSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 0: {
                retVal = CommonTransitions.createEmpty();
            }
        }
        retVal.linearMotion = this.linearMotion;
        return retVal;
    }

    public boolean isLinearMotion() {
        return this.linearMotion;
    }

    public void setLinearMotion(boolean linearMotion) {
        this.linearMotion = linearMotion;
    }

    public static boolean isDefaultLinearMotion() {
        return defaultLinearMotion;
    }

    public static void setDefaultLinearMotion(boolean aDefaultLinearMotion) {
        defaultLinearMotion = aDefaultLinearMotion;
    }
}

