/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLListItem;

class HTMLBullet
extends HTMLListItem {
    static final String[] CSS_UL_TYPES = new String[]{"none", "disc", "circle", "square"};
    private static final int BULLET_NONE = 0;
    private static final int BULLET_DISC = 1;
    private static final int BULLET_CIRCLE = 2;
    private static final int BULLET_SQUARE = 3;
    int level;
    int fontHeight;
    int color;
    HTMLComponent htmlC;

    static int convertULString(String listTypeStr) {
        if (listTypeStr == null) {
            return -1;
        }
        for (int j = 0; j < CSS_UL_TYPES.length; ++j) {
            if (!listTypeStr.equalsIgnoreCase(CSS_UL_TYPES[j])) continue;
            return j;
        }
        return -1;
    }

    public HTMLBullet(int level, int fontHeight, int color, HTMLComponent htmlC) {
        this.level = level;
        this.fontHeight = fontHeight;
        this.color = color;
        this.htmlC = htmlC;
        this.getStyle().setBgTransparency(0);
        this.setFocusable(false);
    }

    public void setStyleType(int type) {
        if (type != -1) {
            this.level = type;
            this.setShouldCalcPreferredSize(true);
            this.repaint();
        }
    }

    public void setImage(String imageUrl) {
        if (imageUrl != null) {
            this.htmlC.getThreadQueue().add(this, this.htmlC.convertURL(imageUrl));
        }
    }

    public void paint(Graphics g) {
        if (this.getIcon() != null) {
            super.paint(g);
            return;
        }
        int size = this.fontHeight / 3;
        g.setColor(this.color);
        if (this.level == 1) {
            g.fillArc(this.getX() + (this.getWidth() - (size += 2)) / 2, this.getY() + (this.getHeight() - size) / 2, size, size, 0, 360);
        } else if (this.level == 2) {
            g.drawArc(this.getX() + (this.getWidth() - size) / 2, this.getY() + (this.getHeight() - size) / 2, size, size, 0, 360);
        } else if (this.level == 3) {
            g.fillRect(this.getX() + (this.getWidth() - size) / 2, this.getY() + (this.getHeight() - size) / 2, size, size);
        }
    }

    protected Dimension calcPreferredSize() {
        if (this.getIcon() != null) {
            return super.calcPreferredSize();
        }
        if (this.level == 0) {
            return new Dimension(0, this.fontHeight);
        }
        return new Dimension(this.fontHeight, this.fontHeight);
    }
}

