/*
 * Decompiled with CFR 0.152.
 */
package layout;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import layout.Etykieta;
import layout.Layout;
import layout.Okno;
import layout.Przycisk;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xml {
    public static void parse(Layout layout, String string) throws ParserConfigurationException, SAXException, IOException {
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("okno");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String string2 = element.getAttribute("id");
            int n = Xml.parseS(element.getAttribute("width"));
            int n2 = Xml.parseS(element.getAttribute("height"));
            int n3 = Xml.parseS(element.getAttribute("left"));
            int n4 = Xml.parseS(element.getAttribute("top"));
            Color color = Color.decode(element.getAttribute("color"));
            String string3 = element.getAttribute("tytul");
            Okno okno = new Okno(string2, string3, new Rectangle(n3, n4, n, n2), color);
            Xml.parseEtykieta(layout, (Element)node, okno);
            Xml.parsePrzyciski(layout, (Element)node, okno);
            layout.addOkno(okno);
        }
    }

    private static void parsePrzyciski(Layout layout, Element element, Okno okno) {
        NodeList nodeList = element.getElementsByTagName("przycisk");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("id");
            int n = Xml.parseS(element2.getAttribute("width"));
            int n2 = Xml.parseS(element2.getAttribute("height"));
            int n3 = Xml.parseS(element2.getAttribute("left"));
            int n4 = Xml.parseS(element2.getAttribute("top"));
            Color color = Color.decode(element2.getAttribute("color"));
            String string2 = element2.getAttribute("napis");
            Przycisk przycisk = new Przycisk(string, string2, new Rectangle(n3, n4, n, n2), color);
            layout.addPrzycisk(przycisk);
            Xml.parseDowiazanie(layout, (Element)node, przycisk);
            okno.add(przycisk);
        }
    }

    private static void parseEtykieta(Layout layout, Element element, Okno okno) {
        NodeList nodeList = element.getElementsByTagName("etykieta");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("id");
            int n = Xml.parseS(element2.getAttribute("width"));
            int n2 = Xml.parseS(element2.getAttribute("height"));
            int n3 = Xml.parseS(element2.getAttribute("left"));
            int n4 = Xml.parseS(element2.getAttribute("top"));
            Color color = Color.decode(element2.getAttribute("color"));
            String string2 = element2.getTextContent();
            Etykieta etykieta = new Etykieta(string, string2, new Rectangle(n3, n4, n, n2), color);
            layout.addEtykieta(etykieta);
            okno.add(etykieta);
        }
    }

    private static void parseDowiazanie(Layout layout, Element element, Przycisk przycisk) {
        NodeList nodeList = element.getElementsByTagName("dowiazanie");
        System.out.println(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getTextContent();
            przycisk.addDowiazanie(string);
        }
    }

    private static int parseS(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        int n = Integer.parseInt(string);
        if (n < 0) {
            return 0;
        }
        return n;
    }
}

