/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class EventDispatcher {
    private Vector listeners;
    private Object[] pending;
    private Object pendingEvent;
    private final Runnable callback = new Runnable(){

        public final void run() {
            if (!Display.getInstance().isEdt()) {
                throw new IllegalStateException("This method should not be invoked by external code!");
            }
            if (EventDispatcher.this.pending instanceof ActionListener[]) {
                EventDispatcher.this.fireActionSync((ActionListener[])EventDispatcher.this.pending, (ActionEvent)EventDispatcher.this.pendingEvent);
                return;
            }
            if (EventDispatcher.this.pending instanceof FocusListener[]) {
                EventDispatcher.this.fireFocusSync((FocusListener[])EventDispatcher.this.pending, (Component)EventDispatcher.this.pendingEvent);
                return;
            }
            if (EventDispatcher.this.pending instanceof DataChangedListener[]) {
                EventDispatcher.this.fireDataChangeSync((DataChangedListener[])EventDispatcher.this.pending, ((int[])EventDispatcher.this.pendingEvent)[0], ((int[])EventDispatcher.this.pendingEvent)[1]);
                return;
            }
            if (EventDispatcher.this.pending instanceof SelectionListener[]) {
                EventDispatcher.this.fireSelectionSync((SelectionListener[])EventDispatcher.this.pending, ((int[])EventDispatcher.this.pendingEvent)[0], ((int[])EventDispatcher.this.pendingEvent)[1]);
                return;
            }
            if (EventDispatcher.this.pending instanceof StyleListener[]) {
                Object[] p = (Object[])EventDispatcher.this.pendingEvent;
                EventDispatcher.this.fireStyleChangeSync((StyleListener[])EventDispatcher.this.pending, (String)p[0], (Style)p[1]);
                EventDispatcher.this.pendingEvent = null;
                EventDispatcher.access$002(EventDispatcher.this, null);
                return;
            }
        }
    };

    public synchronized void addListener(Object listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public Vector getListenerVector() {
        return this.listeners;
    }

    public synchronized void removeListener(Object listener) {
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChangeEvent(int index, int type) {
        DataChangedListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new DataChangedListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (DataChangedListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireDataChangeSync(array, type, index);
        } else {
            this.pending = array;
            this.pendingEvent = new int[]{type, index};
            Display.getInstance().callSeriallyAndWait(this.callback);
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStyleChangeEvent(String property, Style source) {
        StyleListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new StyleListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (StyleListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireStyleChangeSync(array, property, source);
        } else {
            this.pending = array;
            this.pendingEvent = new Object[]{property, source};
            Display.getInstance().callSerially(this.callback);
        }
    }

    private void fireDataChangeSync(DataChangedListener[] array, int type, int index) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].dataChanged(type, index);
        }
    }

    private void fireStyleChangeSync(StyleListener[] array, String property, Style source) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].styleChanged(property, source);
        }
    }

    private void fireSelectionSync(SelectionListener[] array, int oldSelection, int newSelection) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].selectionChanged(oldSelection, newSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActionEvent(ActionEvent ev) {
        ActionListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new ActionListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (ActionListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireActionSync(array, ev);
        } else {
            this.pending = array;
            this.pendingEvent = ev;
            Display.getInstance().callSeriallyAndWait(this.callback);
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionEvent(int oldSelection, int newSelection) {
        SelectionListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new SelectionListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (SelectionListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireSelectionSync(array, oldSelection, newSelection);
        } else {
            this.pending = array;
            this.pendingEvent = new int[]{oldSelection, newSelection};
            Display.getInstance().callSeriallyAndWait(this.callback);
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireActionSync(ActionListener[] array, ActionEvent ev) {
        for (int iter = 0; iter < array.length; ++iter) {
            if (ev.isConsumed()) continue;
            array[iter].actionPerformed(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocus(Component c) {
        FocusListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new FocusListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (FocusListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireFocusSync(array, c);
        } else {
            this.pending = array;
            this.pendingEvent = c;
            Display.getInstance().callSeriallyAndWait(this.callback);
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireFocusSync(FocusListener[] array, Component c) {
        if (c.hasFocus()) {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusGained(c);
            }
        } else {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusLost(c);
            }
        }
    }

    static /* synthetic */ Object[] access$002(EventDispatcher x0, Object[] x1) {
        x0.pending = x1;
        return x1;
    }
}

