/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Image;
import com.sun.lwuit.RGBImage;

public class Effects {
    private Effects() {
    }

    public static Image reflectionImage(Image source) {
        return Effects.reflectionImage(source, 0.5f, 120);
    }

    public static Image reflectionImage(Image source, float mirrorRatio, int alphaRatio) {
        return Effects.reflectionImage(source, mirrorRatio, alphaRatio, 0);
    }

    public static Image reflectionImage(Image source, float mirrorRatio, int alphaRatio, int spacing) {
        int w = source.getWidth();
        int h = source.getHeight();
        int mirrorHeight = (int)((float)h * mirrorRatio) * w;
        RGBImage rgbImg = new RGBImage(new int[w * (h + spacing) + mirrorHeight], w, h + ((int)((float)h * mirrorRatio) + spacing));
        source.toRGB(rgbImg, 0, 0, 0, 0, w, h);
        int[] imageData = rgbImg.getRGB();
        for (int iter = 0; iter < mirrorHeight; ++iter) {
            int sourcePos = w * h - iter - 1;
            int off = iter % w;
            off = w - off + iter - off;
            int mirrorPos = imageData.length - (mirrorHeight - off) + spacing * w;
            int color = imageData[sourcePos];
            if ((color & 0xFF000000) == 0 || mirrorPos >= imageData.length) continue;
            int alpha = (int)((float)alphaRatio * ((float)mirrorHeight - (float)iter) / (float)mirrorHeight);
            imageData[mirrorPos] = imageData[sourcePos] & 0xFFFFFF | alpha << 24 & 0xFF000000;
        }
        return rgbImg;
    }
}

