/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class DefaultListModel
implements ListModel {
    private Vector items;
    private EventDispatcher dataListener = new EventDispatcher();
    private EventDispatcher selectionListener = new EventDispatcher();
    private int selectedIndex = 0;

    public DefaultListModel() {
        this.items = new Vector();
    }

    public DefaultListModel(Vector items) {
        this.items = items;
    }

    public DefaultListModel(Object[] items) {
        this.items = DefaultListModel.createVector(items);
    }

    private static Vector createVector(Object[] items) {
        if (items == null) {
            items = new Object[]{};
        }
        Vector<Object> vec = new Vector<Object>(items.length);
        for (int iter = 0; iter < items.length; ++iter) {
            vec.addElement(items[iter]);
        }
        return vec;
    }

    public Object getItemAt(int index) {
        if (index < this.getSize() && index >= 0) {
            return this.items.elementAt(index);
        }
        return null;
    }

    public int getSize() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void addItem(Object item) {
        this.items.addElement(item);
        this.fireDataChangedEvent(1, this.items.size());
    }

    public void setItem(int index, Object item) {
        this.items.setElementAt(item, index);
        this.fireDataChangedEvent(2, index);
    }

    public void addItemAtIndex(Object item, int index) {
        if (index <= this.items.size()) {
            this.items.insertElementAt(item, index);
            this.fireDataChangedEvent(1, index);
        }
    }

    public void removeItem(int index) {
        if (index < this.getSize() && index >= 0) {
            this.items.removeElementAt(index);
            if (index != 0) {
                this.setSelectedIndex(index - 1);
            }
            this.fireDataChangedEvent(0, index);
        }
    }

    public void removeAll() {
        while (this.getSize() > 0) {
            this.removeItem(0);
        }
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        this.selectionListener.fireSelectionEvent(oldIndex, this.selectedIndex);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    private void fireDataChangedEvent(int status, int index) {
        this.dataListener.fireDataChangeEvent(index, status);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }
}

