/*
 * Decompiled with CFR 0.152.
 */
package layout;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import layout.Etykieta;
import layout.Layout;
import layout.Okno;
import layout.Przycisk;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xml {
    public static void parse(Layout layout, String fileName) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(fileName);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList eList = doc.getElementsByTagName("okno");
        for (int temp = 0; temp < eList.getLength(); ++temp) {
            Node node = eList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            int width = Xml.parseS(element.getAttribute("width"));
            int height = Xml.parseS(element.getAttribute("height"));
            int left = Xml.parseS(element.getAttribute("left"));
            int top = Xml.parseS(element.getAttribute("top"));
            Color color = Color.decode(element.getAttribute("color"));
            String tytul = element.getAttribute("tytul");
            Okno okno = new Okno(id, tytul, new Rectangle(left, top, width, height), color);
            Xml.parseEtykieta(layout, (Element)node, okno);
            Xml.parsePrzyciski(layout, (Element)node, okno);
            layout.addOkno(okno);
        }
    }

    private static void parsePrzyciski(Layout layout, Element parentNode, Okno okno) {
        NodeList eList = parentNode.getElementsByTagName("przycisk");
        for (int temp = 0; temp < eList.getLength(); ++temp) {
            Node node = eList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            int width = Xml.parseS(element.getAttribute("width"));
            int height = Xml.parseS(element.getAttribute("height"));
            int left = Xml.parseS(element.getAttribute("left"));
            int top = Xml.parseS(element.getAttribute("top"));
            Color color = Color.decode(element.getAttribute("color"));
            String napis = element.getAttribute("napis");
            Przycisk przycisk = new Przycisk(id, napis, new Rectangle(left, top, width, height), color);
            layout.addPrzycisk(przycisk);
            Xml.parseDowiazanie(layout, (Element)node, przycisk);
            okno.add(przycisk);
        }
    }

    private static void parseEtykieta(Layout layout, Element parentNode, Okno okno) {
        NodeList eList = parentNode.getElementsByTagName("etykieta");
        for (int temp = 0; temp < eList.getLength(); ++temp) {
            Node node = eList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            int width = Xml.parseS(element.getAttribute("width"));
            int height = Xml.parseS(element.getAttribute("height"));
            int left = Xml.parseS(element.getAttribute("left"));
            int top = Xml.parseS(element.getAttribute("top"));
            Color color = Color.decode(element.getAttribute("color"));
            String napis = element.getTextContent();
            Etykieta etykieta = new Etykieta(id, napis, new Rectangle(left, top, width, height), color);
            layout.addEtykieta(etykieta);
            okno.add(etykieta);
        }
    }

    private static void parseDowiazanie(Layout layout, Element parentNode, Przycisk przycisk) {
        NodeList eList = parentNode.getElementsByTagName("dowiazanie");
        System.out.println(eList.getLength());
        for (int temp = 0; temp < eList.getLength(); ++temp) {
            Node node = eList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String napis = element.getTextContent();
            przycisk.addDowiazanie(napis);
        }
    }

    private static int parseS(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        int w = Integer.parseInt(s);
        if (w < 0) {
            return 0;
        }
        return w;
    }
}

