/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.plaf.UIManager;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class GameCanvasImplementation
extends LWUITImplementation {
    private static boolean NOKIA = false;
    private boolean minimized;
    private static int[] portableKeyCodes;
    private static int[] portableKeyCodeValues;
    private int alpha = 255;
    private int[] rgbArr;
    private Canvas canvas;
    private static final AlertType[] TYPES;
    static Command CONFIRM_COMMAND;
    private long lastVibrate;
    static Command CANCEL_COMMAND;
    TextBox currentTextBox;
    Component currentTextComponent;
    private boolean flushGraphicsBug;
    static javax.microedition.lcdui.Display display;
    static int[] leftSK;
    static int[] rightSK;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private static boolean drawNegativeOffsetsInRGB;

    protected Canvas createCanvas() {
        return new C();
    }

    public int getKeyboardType() {
        String keyboardType = System.getProperty("com.nokia.keyboard.type");
        if (keyboardType != null) {
            if ("None".equalsIgnoreCase(keyboardType)) {
                if (this.isTouchDevice()) {
                    return 3;
                }
                return 1;
            }
            if ("PhoneKeypad".equalsIgnoreCase(keyboardType)) {
                return 1;
            }
            if ("HalfKeyboard".equalsIgnoreCase(keyboardType)) {
                return 4;
            }
            if ("FullKeyboard".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
            if ("LimitedKeyboard4x10".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
            if ("LimitedKeyboard3x11".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
        }
        return super.getKeyboardType();
    }

    public void init(Object m) {
        this.canvas = this.createCanvas();
        this.canvas.setTitle(null);
        this.canvas.setFullScreenMode(true);
        String platform = System.getProperty("microedition.platform");
        if (platform != null && platform.toUpperCase().indexOf("NOKIA") >= 0) {
            this.flushGraphicsBug = false;
            NOKIA = true;
            Display.getInstance().setTransitionYield(1);
        } else {
            this.flushGraphicsBug = true;
            Display.getInstance().setTransitionYield(-1);
        }
        display = javax.microedition.lcdui.Display.getDisplay((MIDlet)((MIDlet)m));
        this.setSoftKeyCodes((MIDlet)m);
    }

    private void setSoftKeyCodes(MIDlet m) {
        int game;
        this.setKnownSoftKeyCodes();
        try {
            game = this.getGameAction(backSK);
            if (game == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                backSK = -50000;
            }
        }
        catch (Exception ok) {
            // empty catch block
        }
        try {
            game = this.getGameAction(clearSK);
            if (game == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                clearSK = -50000;
            }
            if ((game = this.getGameAction(backspaceSK)) == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                backspaceSK = -50000;
            }
        }
        catch (Exception ok) {
            // empty catch block
        }
        String tmpSoftKey = m.getAppProperty("SoftKey-Right");
        if (tmpSoftKey != null && !"".equals(tmpSoftKey)) {
            GameCanvasImplementation.rightSK[0] = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Right2")) != null && !"".equals(tmpSoftKey)) {
            rightSK = new int[]{rightSK[0], Integer.valueOf(tmpSoftKey)};
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Left")) != null && !"".equals(tmpSoftKey)) {
            GameCanvasImplementation.leftSK[0] = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Back")) != null && !"".equals(tmpSoftKey)) {
            backSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Clear")) != null && !"".equals(tmpSoftKey)) {
            clearSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Backspace")) != null && !"".equals(tmpSoftKey)) {
            backspaceSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("isThirdSoftButtonSupported")) != null && "true".equals(tmpSoftKey.toLowerCase().trim())) {
            Display.getInstance().setThirdSoftButton(true);
        }
    }

    private void setKnownSoftKeyCodes() {
        try {
            Class.forName("com.siemens.mp.game.Light");
            GameCanvasImplementation.leftSK[0] = -1;
            GameCanvasImplementation.rightSK[0] = -4;
            clearSK = -12;
            backspaceSK = -12;
            return;
        }
        catch (ClassNotFoundException _ex) {
            try {
                Class.forName("com.motorola.phonebook.PhoneBookRecord");
                GameCanvasImplementation.leftSK[0] = -21;
                GameCanvasImplementation.rightSK[0] = -22;
                return;
            }
            catch (ClassNotFoundException _ex2) {
                try {
                    Class.forName("com.nokia.mid.ui.FullCanvas");
                    GameCanvasImplementation.leftSK[0] = -6;
                    GameCanvasImplementation.rightSK[0] = -7;
                    clearSK = -8;
                    backspaceSK = -8;
                    String p = System.getProperty("microedition.platform");
                    if (p != null && p.toUpperCase().indexOf("NOKIA") >= 0) {
                        backspaceSK = 8;
                    }
                    return;
                }
                catch (Throwable ex) {
                    try {
                        Class.forName("net.rim.device.api.system.Application");
                        GameCanvasImplementation.leftSK[0] = 113;
                        rightSK = new int[]{112, 111};
                        clearSK = 8;
                        backspaceSK = 8;
                        return;
                    }
                    catch (ClassNotFoundException ex2) {
                        try {
                            Class.forName("com.mot.iden.util.Base64");
                            clearSK = -5000;
                            backspaceSK = -5000;
                            GameCanvasImplementation.leftSK[0] = -20;
                            GameCanvasImplementation.rightSK[0] = -21;
                            this.setFireValue(-23);
                            return;
                        }
                        catch (Throwable ex3) {
                            try {
                                Class.forName("mmpp.media.MediaPlayer");
                                clearSK = -204;
                                backspaceSK = -204;
                            }
                            catch (ClassNotFoundException ex4) {
                                // empty catch block
                            }
                            try {
                                if (this.canvas.getKeyName(-6).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = -6;
                                    GameCanvasImplementation.rightSK[0] = -7;
                                    return;
                                }
                                if (this.canvas.getKeyName(21).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = 21;
                                    GameCanvasImplementation.rightSK[0] = 22;
                                    return;
                                }
                            }
                            catch (Exception ex5) {
                                // empty catch block
                            }
                            boolean leftInit = false;
                            boolean rightInit = false;
                            for (int i = -127; i < 127; ++i) {
                                if (leftInit && rightInit) {
                                    return;
                                }
                                try {
                                    if (this.canvas.getKeyName(i).toUpperCase().indexOf("SOFT") < 0) continue;
                                    if (this.canvas.getKeyName(i).indexOf("1") >= 0) {
                                        GameCanvasImplementation.leftSK[0] = i;
                                        leftInit = true;
                                    }
                                    if (this.canvas.getKeyName(i).indexOf("2") < 0) continue;
                                    GameCanvasImplementation.rightSK[0] = i;
                                    rightInit = true;
                                    continue;
                                }
                                catch (Exception ex6) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    void setFireValue(int key) {
        try {
            this.getKeyCode(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameCanvasImplementation.portableKeyCodeValues[4] = key;
    }

    public void vibrate(int duration) {
        long now = System.currentTimeMillis();
        if (now > this.lastVibrate) {
            this.lastVibrate = now + (long)(duration * 3);
            display.vibrate(duration);
        }
    }

    public void flashBacklight(int duration) {
        display.flashBacklight(duration);
    }

    public int getDisplayWidth() {
        return this.canvas.getWidth();
    }

    public int getDisplayHeight() {
        return this.canvas.getHeight();
    }

    public void editString(Component cmp, int maxSize, int constraint, String text) {
        UIManager m = UIManager.getInstance();
        CONFIRM_COMMAND = new Command(m.localize("ok", "OK"), 4, 1);
        CANCEL_COMMAND = new Command(m.localize("cancel", "Cancel"), 3, 2);
        this.currentTextBox = new TextBox("", "", maxSize, 0);
        this.currentTextBox.setCommandListener((CommandListener)this.canvas);
        this.currentTextBox.addCommand(CONFIRM_COMMAND);
        this.currentTextBox.addCommand(CANCEL_COMMAND);
        this.currentTextComponent = cmp;
        this.currentTextBox.setMaxSize(maxSize);
        this.currentTextBox.setString(text);
        this.currentTextBox.setConstraints(constraint);
        display.setCurrent((Displayable)this.currentTextBox);
        ((C)this.canvas).setDone(false);
        Display.getInstance().invokeAndBlock((C)this.canvas);
    }

    public void saveTextEditingState() {
        String text = this.currentTextBox.getString();
        Display.getInstance().onEditingComplete(this.currentTextComponent, text);
        this.currentTextBox = null;
        ((C)this.canvas).setDone(true);
    }

    public void setFlashGraphicsBug(boolean flushGraphicsBug) {
        this.flushGraphicsBug = flushGraphicsBug;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    public void flushGraphics(int x, int y, int width, int height) {
        Form current = this.getCurrentForm();
        if (!this.flushGraphicsBug || current != null && current.hasMedia()) {
            ((C)this.canvas).flushGraphics(x, y, width, height);
        } else {
            ((C)this.canvas).flushGraphics();
        }
    }

    public void flushGraphics() {
        ((C)this.canvas).flushGraphics();
    }

    public void getRGB(Object nativeImage, int[] arr, int offset, int x, int y, int width, int height) {
        ((Image)nativeImage).getRGB(arr, offset, width, x, y, width, height);
    }

    public Object createImage(int[] rgb, int width, int height) {
        return Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
    }

    public Object createImage(String path) throws IOException {
        return Image.createImage((String)path);
    }

    public Object createImage(InputStream i) throws IOException {
        return Image.createImage((InputStream)i);
    }

    public Object createMutableImage(int width, int height, int fillColor) {
        Image i = Image.createImage((int)width, (int)height);
        if (fillColor != -1) {
            Graphics g = i.getGraphics();
            g.setColor(fillColor);
            g.fillRect(0, 0, width, height);
            g.drawRect(0, 0, width - 1, height - 1);
        }
        return i;
    }

    public Object createImage(byte[] bytes, int offset, int len) {
        return Image.createImage((byte[])bytes, (int)offset, (int)len);
    }

    public int getImageWidth(Object i) {
        return ((Image)i).getWidth();
    }

    public int getImageHeight(Object i) {
        return ((Image)i).getHeight();
    }

    public Object scale(Object nativeImage, int width, int height) {
        Image image = (Image)nativeImage;
        int srcWidth = image.getWidth();
        int srcHeight = image.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return image;
        }
        int[] currentArray = new int[srcWidth];
        int[] destinationArray = new int[width * height];
        this.scaleArray(image, srcWidth, srcHeight, height, width, currentArray, destinationArray);
        return this.createImage(destinationArray, width, height);
    }

    private void scaleArray(Image currentImage, int srcWidth, int srcHeight, int height, int width, int[] currentArray, int[] destinationArray) {
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int xPos = xRatio / 2;
        int yPos = yRatio / 2;
        for (int y = 0; y < height; ++y) {
            int srcY = yPos >> 16;
            this.getRGB(currentImage, currentArray, 0, 0, srcY, srcWidth, 1);
            for (int x = 0; x < width; ++x) {
                int srcX = xPos >> 16;
                int destPixel = x + y * width;
                if (destPixel >= 0 && destPixel < destinationArray.length && srcX < currentArray.length) {
                    destinationArray[destPixel] = currentArray[srcX];
                }
                xPos += xRatio;
            }
            yPos += yRatio;
            xPos = xRatio / 2;
        }
    }

    public void drawImageRotated(Object graphics, Object img, int x, int y, int degrees) {
        int t;
        Image i = (Image)img;
        switch (degrees % 360) {
            case 0: {
                this.drawImage(graphics, img, x, y);
                return;
            }
            case 90: {
                t = 5;
                break;
            }
            case 180: {
                t = 3;
                break;
            }
            case 270: {
                t = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for drawImageRotated: " + degrees);
            }
        }
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), t, x, y, 20);
    }

    public boolean isRotationDrawingSupported() {
        return true;
    }

    public int getSoftkeyCount() {
        return 2;
    }

    public int[] getSoftkeyCode(int index) {
        if (index == 0) {
            return leftSK;
        }
        if (index == 1) {
            return rightSK;
        }
        return null;
    }

    public int getClearKeyCode() {
        return clearSK;
    }

    public int getBackspaceKeyCode() {
        return backspaceSK;
    }

    public int getBackKeyCode() {
        return backSK;
    }

    public int getGameAction(int keyCode) {
        try {
            if (keyCode >= 48) {
                return 0;
            }
            if (portableKeyCodes != null) {
                for (int iter = 0; iter < portableKeyCodeValues.length; ++iter) {
                    if (portableKeyCodeValues[iter] != keyCode) continue;
                    return portableKeyCodes[iter];
                }
            }
            return this.canvas.getGameAction(keyCode);
        }
        catch (IllegalArgumentException err) {
            return 0;
        }
    }

    public int getKeyCode(int gameAction) {
        if (portableKeyCodes == null) {
            portableKeyCodes = new int[]{6, 2, 5, 1, 8};
            portableKeyCodeValues = new int[5];
            int currentValue = -500;
            int offset = 0;
            while (offset < portableKeyCodeValues.length) {
                --currentValue;
                try {
                    if (this.canvas.getGameAction(currentValue) != 0) {
                        continue;
                    }
                }
                catch (IllegalArgumentException ignor) {
                    // empty catch block
                }
                GameCanvasImplementation.portableKeyCodeValues[offset] = currentValue;
                ++offset;
            }
        }
        for (int iter = 0; iter < portableKeyCodes.length; ++iter) {
            if (portableKeyCodes[iter] != gameAction) continue;
            return portableKeyCodeValues[iter];
        }
        return 0;
    }

    public boolean isTouchDevice() {
        return this.canvas.hasPointerEvents();
    }

    public void setNativeFont(Object graphics, Object font) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.setFont(this.font(font));
    }

    public int getClipX(Object graphics) {
        Graphics nativeGraphics = (Graphics)graphics;
        return nativeGraphics.getClipX();
    }

    public int getClipY(Object graphics) {
        Graphics nativeGraphics = (Graphics)graphics;
        return nativeGraphics.getClipY();
    }

    public int getClipWidth(Object graphics) {
        Graphics nativeGraphics = (Graphics)graphics;
        return nativeGraphics.getClipWidth();
    }

    public int getClipHeight(Object graphics) {
        Graphics nativeGraphics = (Graphics)graphics;
        return nativeGraphics.getClipHeight();
    }

    public void setClip(Object graphics, int x, int y, int width, int height) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.setClip(x, y, width, height);
    }

    public void clipRect(Object graphics, int x, int y, int width, int height) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.clipRect(x, y, width, height);
    }

    public void drawLine(Object graphics, int x1, int y1, int x2, int y2) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(Object graphics, int x, int y, int w, int h) {
        if (this.isAlphaGlobal()) {
            Graphics nativeGraphics = (Graphics)graphics;
            nativeGraphics.fillRect(x, y, w, h);
            nativeGraphics.drawRect(x, y, w - 1, h - 1);
            return;
        }
        if (this.alpha == 0) {
            return;
        }
        if (this.alpha == 255) {
            Graphics nativeGraphics = (Graphics)graphics;
            nativeGraphics.fillRect(x, y, w, h);
            nativeGraphics.drawRect(x, y, w - 1, h - 1);
        } else {
            int transparencyLevel = this.alpha << 24;
            int color = this.getColor(graphics) & 0xFFFFFF;
            color |= transparencyLevel;
            if (this.rgbArr == null || this.rgbArr.length < w) {
                this.rgbArr = new int[w];
            }
            for (int i = 0; i < w; ++i) {
                this.rgbArr[i] = color;
            }
            int rgbX = x;
            int rgbY = y;
            if (rgbX < 0 && rgbX + w > 0) {
                w = rgbX + w;
                rgbX = 0;
            }
            if (w < 0) {
                return;
            }
            int clipY = this.getClipY(graphics);
            int clipHeight = this.getClipHeight(graphics);
            int clipBottomY = clipHeight + clipY;
            for (int i = 0; i < h; ++i) {
                int currentY;
                if (rgbX < 0 || rgbY + i < 0 || (currentY = rgbY + i) < clipY || currentY > clipBottomY) continue;
                this.drawRGB(graphics, this.rgbArr, 0, rgbX, currentY, w, 1, true);
            }
        }
    }

    public void drawRect(Object graphics, int x, int y, int width, int height) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawRect(x, y, width, height);
    }

    public void drawRoundRect(Object graphics, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(Object graphics, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillArc(Object graphics, int x, int y, int width, int height, int startAngle, int arcAngle) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawArc(Object graphics, int x, int y, int width, int height, int startAngle, int arcAngle) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void setColor(Object graphics, int RGB) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.setColor(RGB);
    }

    public int getColor(Object graphics) {
        Graphics nativeGraphics = (Graphics)graphics;
        return nativeGraphics.getColor();
    }

    public void setAlpha(Object graphics, int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha(Object graphics) {
        return this.alpha;
    }

    public void drawString(Object graphics, String str, int x, int y) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawString(str, x, y, 20);
    }

    public void drawImage(Object graphics, Object img, int x, int y) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.drawImage((Image)img, x, y, 20);
    }

    public void fillTriangle(Object graphics, int x1, int y1, int x2, int y2, int x3, int y3) {
        Graphics nativeGraphics = (Graphics)graphics;
        nativeGraphics.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public void drawRGB(Object graphics, int[] rgbData, int offset, int x, int y, int w, int h, boolean processAlpha) {
        Graphics nativeGraphics = (Graphics)graphics;
        int rgbX = x;
        int rgbY = y;
        if (rgbX >= 0 && rgbY >= 0) {
            nativeGraphics.drawRGB(rgbData, offset, w, rgbX, rgbY, w, h, processAlpha);
            return;
        }
        if (drawNegativeOffsetsInRGB) {
            try {
                nativeGraphics.drawRGB(rgbData, offset, w, rgbX, rgbY, w, h, processAlpha);
                return;
            }
            catch (RuntimeException e) {
                drawNegativeOffsetsInRGB = false;
            }
        }
        if (rgbX < 0 && rgbX + w > 0 && w < rgbData.length) {
            for (int i = 1; i <= rgbData.length / w; ++i) {
                offset = -rgbX + w * (i - 1);
                if (++rgbY < 0) continue;
                nativeGraphics.drawRGB(rgbData, offset, w + rgbX, 0, rgbY, w + rgbX, 1, processAlpha);
            }
        }
    }

    public Object getVideoControl(Object player) {
        VideoControl vidc = (VideoControl)((Player)player).getControl("VideoControl");
        vidc.initDisplayMode(1, (Object)this.canvas);
        return vidc;
    }

    public int numAlphaLevels() {
        return display.numAlphaLevels();
    }

    public int numColors() {
        return display.numColors();
    }

    public void playDialogSound(int type) {
        if (--type >= 0 && type < TYPES.length) {
            TYPES[type].playSound(display);
        }
    }

    public void confirmControlView() {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (display.getCurrent() != this.canvas || !this.canvas.isShown()) {
            this.setCurrent((Displayable)this.canvas);
        }
    }

    private void setCurrent(Displayable d) {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (!this.minimized) {
            if (d instanceof Canvas) {
                ((Canvas)d).setFullScreenMode(true);
            }
            display.setCurrent(d);
        }
    }

    public Object getNativeGraphics() {
        return ((C)this.canvas).getGraphics();
    }

    public Object getNativeGraphics(Object image) {
        return ((Image)image).getGraphics();
    }

    public void translate(Object graphics, int x, int y) {
    }

    public int getTranslateX(Object graphics) {
        return 0;
    }

    public int getTranslateY(Object graphics) {
        return 0;
    }

    public int charsWidth(Object nativeFont, char[] ch, int offset, int length) {
        if (NOKIA) {
            return this.font(nativeFont).stringWidth(new String(ch, offset, length));
        }
        return this.font(nativeFont).charsWidth(ch, offset, length);
    }

    public int stringWidth(Object nativeFont, String str) {
        return this.font(nativeFont).stringWidth(str);
    }

    public int charWidth(Object nativeFont, char ch) {
        return this.font(nativeFont).charWidth(ch);
    }

    public int getHeight(Object nativeFont) {
        return this.font(nativeFont).getHeight();
    }

    public Object createFont(int face, int style, int size) {
        return Font.getFont((int)face, (int)style, (int)size);
    }

    public Object getDefaultFont() {
        return Font.getDefaultFont();
    }

    public int getFace(Object nativeFont) {
        return this.font(nativeFont).getFace();
    }

    public int getSize(Object nativeFont) {
        return this.font(nativeFont).getSize();
    }

    public int getStyle(Object nativeFont) {
        return this.font(nativeFont).getStyle();
    }

    private Font font(Object f) {
        if (f == null) {
            return (Font)this.getDefaultFont();
        }
        return (Font)f;
    }

    public Object createVideoComponent(Object player) {
        if (((Player)player).getState() < 200) {
            throw new IllegalArgumentException("player must be in a realized state");
        }
        return this.getVideoControl(player);
    }

    public int getVideoWidth(Object videoControl) {
        return ((VideoControl)videoControl).getSourceWidth();
    }

    public int getVideoHeight(Object videoControl) {
        return ((VideoControl)videoControl).getSourceHeight();
    }

    public void setVideoVisible(Object vc, boolean visible) {
        ((VideoControl)vc).setVisible(visible);
    }

    public void startVideo(Object player, Object videoControl) {
        try {
            ((VideoControl)videoControl).setVisible(true);
            ((Player)player).start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stopVideo(Object player, Object videoControl) {
        try {
            ((Player)player).stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void setVideoLoopCount(Object player, int count) {
        ((Player)player).setLoopCount(count);
    }

    public long getMediaTime(Object player) {
        return ((Player)player).getMediaTime();
    }

    public long setMediaTime(Object player, long now) {
        try {
            return ((Player)player).setMediaTime(now);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }

    public void paintVideo(Component cmp, boolean fullScreen, Object nativeGraphics, Object video, Object player) {
        try {
            VideoControl vidc = (VideoControl)video;
            if (fullScreen) {
                vidc.setDisplayLocation(0, 0);
                vidc.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
            } else {
                vidc.setDisplayLocation(cmp.getAbsoluteX(), cmp.getAbsoluteY());
                int w = cmp.getWidth();
                int h = cmp.getHeight();
                if (vidc.getDisplayWidth() != w || vidc.getDisplayHeight() != h) {
                    vidc.setDisplaySize(w, h);
                }
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public boolean minimizeApplication() {
        try {
            this.minimized = true;
            display.setCurrent(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public void restoreMinimizedApplication() {
        try {
            this.minimized = false;
            display.setCurrent((Displayable)this.canvas);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    static {
        TYPES = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING};
        leftSK = new int[]{-6};
        rightSK = new int[]{-7};
        backSK = -11;
        clearSK = -8;
        backspaceSK = -8;
        drawNegativeOffsetsInRGB = true;
    }

    private class C
    extends GameCanvas
    implements CommandListener,
    Runnable {
        private boolean done;
        private Graphics gfx;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                Object object = GameCanvasImplementation.this.getDisplayLock();
                synchronized (object) {
                    try {
                        GameCanvasImplementation.this.getDisplayLock().wait(50L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDone(boolean done) {
            this.done = done;
            Object object = GameCanvasImplementation.this.getDisplayLock();
            synchronized (object) {
                GameCanvasImplementation.this.getDisplayLock().notify();
            }
        }

        public void commandAction(Command c, Displayable d) {
            if (d == GameCanvasImplementation.this.currentTextBox) {
                display.setCurrent((Displayable)GameCanvasImplementation.this.canvas);
                if (c == CONFIRM_COMMAND) {
                    String text = GameCanvasImplementation.this.currentTextBox.getString();
                    Display.getInstance().onEditingComplete(GameCanvasImplementation.this.currentTextComponent, text);
                }
                GameCanvasImplementation.this.currentTextBox = null;
                ((C)GameCanvasImplementation.this.canvas).setDone(true);
            }
        }

        C() {
            super(false);
        }

        public Graphics getGraphics() {
            if (this.gfx == null) {
                this.gfx = super.getGraphics();
            }
            return this.gfx;
        }

        protected void keyPressed(int keyCode) {
            GameCanvasImplementation.this.keyPressed(keyCode);
        }

        protected void keyReleased(int keyCode) {
            GameCanvasImplementation.this.keyReleased(keyCode);
        }

        protected void pointerDragged(int x, int y) {
            GameCanvasImplementation.this.pointerDragged(x, y);
        }

        protected void pointerPressed(int x, int y) {
            GameCanvasImplementation.this.pointerPressed(x, y);
        }

        protected void pointerReleased(int x, int y) {
            GameCanvasImplementation.this.pointerReleased(x, y);
        }

        protected void sizeChanged(int w, int h) {
            GameCanvasImplementation.this.sizeChanged(w, h);
        }

        protected void hideNotify() {
            GameCanvasImplementation.this.hideNotify();
        }

        protected void showNotify() {
            GameCanvasImplementation.this.showNotify();
        }
    }
}

